/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class BeanUtil {
    static final Logger logger = LoggerFactory.getLogger((String)BeanUtil.class.getName());

    private BeanUtil() {
    }

    public static void copyBean(Object source, Object target, String ... ignores) {
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignores);
    }

    public static <T> List<T> copyBeanList(Iterable iterable, Class<T> targetClazz) {
        ArrayList<T> newList = new ArrayList<T>();
        for (Object o : iterable) {
            try {
                T t = targetClazz.newInstance();
                BeanUtils.copyProperties(o, t);
                newList.add(t);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
        return newList;
    }

    public static <T> Page<T> copyBeanPage(Page page, Pageable pageable, Class<T> targetClazz) {
        List<T> newList = BeanUtil.copyBeanList((Iterable)page, targetClazz);
        return new PageImpl(newList, pageable, page.getTotalElements());
    }

    public static <T> List<String> getIds(List<T> list, Class clazz, String methodName) {
        ArrayList<String> ids = new ArrayList<String>(list.size());
        try {
            Method m = clazz.getMethod(methodName, new Class[0]);
            for (T t : list) {
                String id = (String)m.invoke(t, new Object[0]);
                ids.add(id);
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
        return ids;
    }
}

