/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.support.hibernate.type.json.internal;

import cn.gtmap.gtc.resource.support.hibernate.type.json.internal.JacksonUtil;
import java.util.Properties;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.usertype.DynamicParameterizedType;

public class JsonTypeDescriptor
extends AbstractTypeDescriptor<Object>
implements DynamicParameterizedType {
    private Class<?> jsonObjectClass;

    public JsonTypeDescriptor() {
        super(Object.class, (MutabilityPlan)new MutableMutabilityPlan<Object>(){

            protected Object deepCopyNotNull(Object value) {
                return JacksonUtil.clone(value);
            }
        });
    }

    public void setParameterValues(Properties parameters) {
        this.jsonObjectClass = ((DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType")).getReturnedClass();
    }

    public boolean areEqual(Object one, Object another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return JacksonUtil.toJsonNode(JacksonUtil.toString(one)).equals((Object)JacksonUtil.toJsonNode(JacksonUtil.toString(another)));
    }

    public String toString(Object value) {
        return JacksonUtil.toString(value);
    }

    public Object fromString(String string) {
        return JacksonUtil.fromString(string, this.jsonObjectClass);
    }

    public <X> X unwrap(Object value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        if (Object.class.isAssignableFrom(type)) {
            return (X)JacksonUtil.toJsonNode(this.toString(value));
        }
        throw this.unknownUnwrap(type);
    }

    public <X> Object wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        return this.fromString(value.toString());
    }
}

