/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;
import cn.gtmap.gtc.resource.domain.core.TimeCoverage;
import cn.gtmap.gtc.resource.domain.core.Title;
import cn.gtmap.gtc.resource.domain.core.Type;
import cn.gtmap.gtc.resource.domain.resource.metadata.Capable;
import cn.gtmap.gtc.resource.domain.resource.metadata.Catalog;
import cn.gtmap.gtc.resource.domain.resource.metadata.Keyword;
import cn.gtmap.gtc.resource.domain.resource.metadata.ResourceApply;
import cn.gtmap.gtc.resource.domain.resource.metadata.ResourceStatus;
import cn.gtmap.gtc.resource.domain.resource.metadata.Responsible;
import cn.gtmap.gtc.resource.domain.resource.metadata.SpatialCoverage;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Table(name="gt_resource", indexes={@Index(columnList="title", name="res_title_idx"), @Index(columnList="type", name="res_type_idx"), @Index(columnList="creator", name="res_creator_idx"), @Index(columnList="publisher", name="res_publisher_idx"), @Index(columnList="spatial_coverage_id", name="res_sp_co_idx")})
public class Resource<T>
extends BaseEntity
implements Title,
Type,
TimeCoverage {
    private String title;
    private String description;
    private List<Keyword> keywords;
    private String type;
    @Column(name="type_id", columnDefinition="varchar(96)")
    private String typeId;
    private String format;
    private String creator;
    private String publisher;
    private Date startAt;
    private Date endAt;
    private SpatialCoverage spatialCoverage;
    private List<Resource> relations;
    private String rights;
    private String source;
    private List<Catalog> catalogs;
    private List<Capable> capables;
    private Responsible responsible;
    private String icon;
    private String regionCode;
    @Column(nullable=false, columnDefinition="INT default 0")
    private Integer weight;
    @Column(nullable=true)
    private String status;
    @Column(name="permission")
    private String permission;
    @Column(name="resourceGxzq")
    private String resourceGxzq;
    @Column(name="dataResource")
    private String dataResource;
    private String ndStr;
    @Column(name="legend", columnDefinition="varchar(255)")
    private String legend;
    private Integer checked = 1;
    private Integer onlineStatus = 0;
    private ResourceStatus resourceStatus;
    @Column(columnDefinition="INT default 1")
    private int isPub = 1;
    private List<ResourceApply> resourceApplyForeign;

    public String getResourceGxzq() {
        return this.resourceGxzq;
    }

    public void setResourceGxzq(String resourceGxzq) {
        this.resourceGxzq = resourceGxzq;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public Resource setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Resource setDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonIgnore
    @ManyToMany
    @JoinTable(name="gt_res_kw_ref", joinColumns={@JoinColumn(name="resource_id")}, inverseJoinColumns={@JoinColumn(name="keyword_id")})
    public List<Keyword> getKeywords() {
        return this.keywords;
    }

    public Resource setKeywords(List<Keyword> keywords) {
        this.keywords = keywords;
        return this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Resource setType(String type) {
        this.type = type;
        return this;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    @Override
    public Date getEndAt() {
        return this.endAt;
    }

    public String getFormat() {
        return this.format;
    }

    public Resource setFormat(String format) {
        this.format = format;
        return this;
    }

    public String getCreator() {
        return this.creator;
    }

    public Resource setCreator(String creator) {
        this.creator = creator;
        return this;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public Resource setPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    public Resource setEndAt(Date endAt) {
        this.endAt = endAt;
        return this;
    }

    @JsonIgnore
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    public SpatialCoverage getSpatialCoverage() {
        return this.spatialCoverage;
    }

    public Resource setSpatialCoverage(SpatialCoverage spatialCoverage) {
        this.spatialCoverage = spatialCoverage;
        return this;
    }

    @JsonIgnore
    @ManyToMany
    @JoinTable(name="gt_res_self_ref")
    public List<Resource> getRelations() {
        return this.relations;
    }

    public Resource setRelations(List<Resource> relations) {
        this.relations = relations;
        return this;
    }

    public String getRights() {
        return this.rights;
    }

    public Resource setRights(String rights) {
        this.rights = rights;
        return this;
    }

    @JsonIgnore
    @Basic(fetch=FetchType.LAZY)
    @Lob
    public String getSource() {
        return this.source;
    }

    public Resource setSource(T source) {
        if (!(source instanceof String)) {
            try {
                this.source = JSON.toJSONString(source);
                return this.source;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                return this;
            }
        }
        this.source = String.valueOf(source);
        return this;
    }

    @JsonIgnore
    @ManyToMany(mappedBy="resources", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    public List<Catalog> getCatalogs() {
        return this.catalogs;
    }

    public Resource setCatalogs(List<Catalog> catalogs) {
        this.catalogs = catalogs;
        return this;
    }

    @Override
    public Date getStartAt() {
        return this.startAt;
    }

    public void setStartAt(Date startAt) {
        this.startAt = startAt;
    }

    @JsonIgnore
    @OneToMany(mappedBy="resource", fetch=FetchType.LAZY)
    public List<Capable> getCapables() {
        return this.capables;
    }

    public Resource setCapables(List<Capable> capables) {
        this.capables = capables;
        return this;
    }

    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    public Responsible getResponsible() {
        return this.responsible;
    }

    public void setResponsible(Responsible responsible) {
        this.responsible = responsible;
    }

    public boolean equals(Object o) {
        return o instanceof Resource && this.getId().equals(((Resource)o).getId());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getIcon() {
        return this.icon;
    }

    public Resource setIcon(String icon) {
        this.icon = icon;
        return this;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public Resource setRegionCode(String regionCode) {
        this.regionCode = regionCode;
        return this;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDataResource() {
        return this.dataResource;
    }

    public void setDataResource(String dataResource) {
        this.dataResource = dataResource;
    }

    public Integer getChecked() {
        return this.checked;
    }

    public void setChecked(Integer checked) {
        this.checked = checked;
    }

    public String getNdStr() {
        return this.ndStr;
    }

    public void setNdStr(String ndStr) {
        this.ndStr = ndStr;
    }

    public String getLegend() {
        return this.legend;
    }

    public void setLegend(String legend) {
        this.legend = legend;
    }

    @Column(name="online_status")
    public Integer getOnlineStatus() {
        return this.onlineStatus;
    }

    public void setOnlineStatus(Integer onlineStatus) {
        this.onlineStatus = onlineStatus;
    }

    @JsonIgnore
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @ForeignKey(name="none")
    @NotFound(action=NotFoundAction.IGNORE)
    public ResourceStatus getResourceStatus() {
        return this.resourceStatus;
    }

    public void setResourceStatus(ResourceStatus resourceStatus) {
        this.resourceStatus = resourceStatus;
    }

    public int getIsPub() {
        return this.isPub;
    }

    public Resource<T> setIsPub(int isPub) {
        this.isPub = isPub;
        return this;
    }

    @JsonIgnore
    @OneToMany(mappedBy="foreignResource", fetch=FetchType.LAZY)
    public List<ResourceApply> getResourceApplyForeign() {
        return this.resourceApplyForeign;
    }

    public Resource setResourceApplyForeign(List<ResourceApply> resourceApplyForeign) {
        this.resourceApplyForeign = resourceApplyForeign;
        return this;
    }
}

