/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;
import cn.gtmap.gtc.resource.domain.core.Title;
import cn.gtmap.gtc.resource.domain.core.Type;
import cn.gtmap.gtc.resource.domain.resource.metadata.Resource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

@Entity
@Table(name="gt_catalog", indexes={@Index(columnList="title", name="cat_title_idx"), @Index(columnList="type", name="cat_type_idx")})
public class Catalog
extends BaseEntity
implements Title,
Type {
    private String title;
    private String description;
    private String type;
    private String code;
    private int weight;
    private int onlineCount;
    private int offlineCount;
    private Catalog parent;
    private List<Catalog> children;
    private List<Resource> resources;
    private String remark;
    private String expandStr;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public Catalog setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Catalog setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Catalog setType(String type) {
        this.type = type;
        return this;
    }

    public int getWeight() {
        return this.weight;
    }

    public Catalog setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent_id")
    public Catalog getParent() {
        return this.parent;
    }

    public Catalog setParent(Catalog parent) {
        this.parent = parent;
        return this;
    }

    @JsonIgnore
    @OneToMany(mappedBy="parent", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @OrderBy(value="weight asc")
    public List<Catalog> getChildren() {
        return this.children;
    }

    public Catalog setChildren(List<Catalog> children) {
        this.children = children;
        return this;
    }

    @JsonIgnore
    @ManyToMany
    @JoinTable(name="gt_cat_res_ref", joinColumns={@JoinColumn(name="catalog_id")}, inverseJoinColumns={@JoinColumn(name="resource_id")})
    public List<Resource> getResources() {
        return this.resources;
    }

    public Catalog setResources(List<Resource> resources) {
        this.resources = resources;
        return this;
    }

    public String getRemark() {
        return this.remark;
    }

    public Catalog setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    @Column(name="online_count", columnDefinition="int default 0")
    public int getOnlineCount() {
        return this.onlineCount;
    }

    public void setOnlineCount(int onlineCount) {
        this.onlineCount = onlineCount;
    }

    @Column(name="offline_count", columnDefinition="int default 0")
    public int getOfflineCount() {
        return this.offlineCount;
    }

    public void setOfflineCount(int offlineCount) {
        this.offlineCount = offlineCount;
    }

    public String getExpandStr() {
        return this.expandStr;
    }

    public void setExpandStr(String expandStr) {
        this.expandStr = expandStr;
    }
}

