/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;
import cn.gtmap.gtc.resource.domain.core.Order;
import cn.gtmap.gtc.resource.domain.core.Status;
import cn.gtmap.gtc.resource.domain.core.Title;
import cn.gtmap.gtc.resource.domain.core.Url;
import cn.gtmap.gtc.resource.domain.resource.metadata.CapableType;
import cn.gtmap.gtc.resource.domain.resource.metadata.Resource;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="gt_res_capable", indexes={@Index(columnList="title", name="capcable_title_idx"), @Index(columnList="type", name="capable_type_idx")})
public class Capable<T>
extends BaseEntity
implements Title,
Url,
Order,
Status {
    private String title;
    private CapableType type;
    private int weight;
    private String status;
    private String info;
    private String url;
    private Resource resource;
    @Column(name="code")
    private String code;
    @Column(name="layerGxzq")
    private String layerGxzq;
    private String proxyUrl;
    private String version;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public Capable setTitle(String title) {
        this.title = title;
        return this;
    }

    @Enumerated(value=EnumType.STRING)
    public CapableType getType() {
        return this.type;
    }

    public Capable setType(CapableType type) {
        this.type = type;
        return this;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public Capable setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public Capable setStatus(String status) {
        this.status = status;
        return this;
    }

    @Basic(fetch=FetchType.LAZY)
    @Lob
    public String getInfo() {
        return this.info;
    }

    @JsonProperty
    public Capable setInfo(T info) {
        if (!(info instanceof String)) {
            try {
                this.info = JSON.toJSONString(info);
                return this.info;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                return this;
            }
        }
        this.info = String.valueOf(info);
        return this;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public Capable setUrl(String url) {
        this.url = url;
        return this;
    }

    @ManyToOne
    @JoinColumn(name="resource_id")
    public Resource getResource() {
        return this.resource;
    }

    public Capable setResource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public boolean equals(Object obj) {
        String id = "";
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        id = ((Capable)obj).getId();
        return this.getId().equals(id);
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }
}

