/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.domain.resource.dto.resource;

import cn.gtmap.gtc.resource.domain.resource.dto.resource.ResourceView;
import cn.gtmap.gtc.resource.domain.resource.metadata.Resource;
import cn.gtmap.gtc.resource.domain.resource.metadata.Responsible;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.CollectionUtils;

public class ResourceViewBuilder {
    public ResourceView build(Resource resource) {
        if (resource == null) {
            return null;
        }
        ResourceView resourceView = new ResourceView();
        resourceView.setId(resource.getId());
        resourceView.setType(resource.getType());
        resourceView.setTitle(resource.getTitle());
        resourceView.setIcon(resource.getIcon());
        if (!CollectionUtils.isEmpty(resource.getCapables())) {
            resourceView.setCapables(resource.getCapables());
        }
        resourceView.setSpatialCoverage(resource.getSpatialCoverage());
        resourceView.setWeight(resource.getWeight());
        resourceView.setResourceViewList(this.build(resource.getRelations()));
        resourceView.setDataResource(resource.getDataResource());
        resourceView.setChecked(resource.getChecked());
        resourceView.setResponsible(resource.getResponsible());
        resourceView.setCreateAt(resource.getCreateAt());
        resourceView.setUpdateAt(resource.getUpdateAt());
        resourceView.setNdStr(resource.getNdStr());
        resourceView.setPermission(resource.getPermission());
        resourceView.setCreator(resource.getCreator());
        resourceView.setDescription(resource.getDescription());
        resourceView.setIsPub(resource.getIsPub());
        if ("1".equals(resource.getPermission()) || "3".equals(resource.getPermission())) {
            resourceView.setApplyStatus(false);
        } else {
            resourceView.setApplyStatus(true);
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)resource.getSource());
            resourceView.setSource(jsonObject);
        }
        catch (Exception e) {
            resourceView.setSource(null);
            e.printStackTrace();
        }
        return resourceView;
    }

    public List<ResourceView> build(List<Resource> resourceList) {
        if (resourceList == null) {
            return new ArrayList<ResourceView>();
        }
        ArrayList<ResourceView> resourceViewList = new ArrayList<ResourceView>();
        for (Resource resource : resourceList) {
            resourceViewList.add(this.build(resource));
        }
        return resourceViewList;
    }

    private String getValue(Map<String, Object> map, String key) {
        Object value;
        if (map.containsKey(key) && Objects.nonNull(value = map.get(key))) {
            return (String)value;
        }
        return "";
    }

    private Integer getInteger(Map<String, Object> map, String key) {
        Object value;
        if (map.containsKey(key) && Objects.nonNull(value = map.get(key))) {
            return (Integer)value;
        }
        return null;
    }

    private Date getDate(Map<String, Object> map, String key) {
        Object value;
        if (map.containsKey(key) && Objects.nonNull(value = map.get(key))) {
            return (Date)value;
        }
        return null;
    }

    private ResourceView mapBbuild(Map<String, Object> map) {
        if (CollectionUtils.isEmpty(map)) {
            return null;
        }
        ResourceView resourceView = new ResourceView();
        resourceView.setId(this.getValue(map, "id"));
        resourceView.setType(this.getValue(map, "type"));
        resourceView.setTitle(this.getValue(map, "title"));
        resourceView.setIcon(this.getValue(map, "icon"));
        resourceView.setWeight(this.getInteger(map, "weight"));
        resourceView.setDataResource(this.getValue(map, "data_resource"));
        resourceView.setChecked(this.getInteger(map, "checked"));
        resourceView.setCreateAt(this.getDate(map, "create_at"));
        resourceView.setUpdateAt(this.getDate(map, "update_at"));
        resourceView.setNdStr(this.getValue(map, "nd_str"));
        resourceView.setPermission(this.getValue(map, "permission"));
        resourceView.setCreator(this.getValue(map, "creator"));
        resourceView.setDescription(this.getValue(map, "description"));
        resourceView.setIsPub(this.getInteger(map, "is_pub"));
        if ("1".equals(resourceView.getPermission()) || "3".equals(resourceView.getPermission())) {
            resourceView.setApplyStatus(false);
        } else {
            resourceView.setApplyStatus(true);
        }
        Responsible responsible = new Responsible();
        responsible.setOrgnizationName(this.getValue(map, "orgnization_name"));
        resourceView.setResponsible(responsible);
        return resourceView;
    }

    public List<ResourceView> listBuild(List<Map<String, Object>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<ResourceView>();
        }
        ArrayList<ResourceView> resourceViewList = new ArrayList<ResourceView>();
        for (Map<String, Object> map : list) {
            resourceViewList.add(this.mapBbuild(map));
        }
        return resourceViewList;
    }
}

