/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.domain.resource.dto.resource;

import cn.gtmap.gtc.resource.domain.resource.dto.resource.CatalogView;
import cn.gtmap.gtc.resource.domain.resource.metadata.Catalog;
import cn.gtmap.gtc.resource.utils.BeanUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Catalog build(CatalogView catalogView) {
        if (catalogView == null) {
            return null;
        }
        Catalog catalog = new Catalog();
        catalog.setId(catalogView.getId());
        catalog.setTitle(catalogView.getTitle());
        catalog.setDescription(catalogView.getDescription());
        catalog.setType(catalogView.getType());
        Catalog parentCatalog = new Catalog();
        if (catalogView.getParent() != null) {
            BeanUtil.copyBean(catalogView.getParent(), parentCatalog, new String[0]);
            catalog.setParent(parentCatalog);
        }
        catalog.setWeight(catalogView.getWeight());
        catalog.setCode(catalogView.getCode());
        try {
            catalog.setChildren(this.build(catalogView.getChildren()));
        }
        catch (Exception e) {
            this.logger.error("catalog\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        return catalog;
    }

    public List<Catalog> build(List<CatalogView> catalogViewList) {
        if (catalogViewList == null) {
            return Collections.emptyList();
        }
        ArrayList<Catalog> catalogList = new ArrayList<Catalog>();
        for (CatalogView catalogView : catalogViewList) {
            catalogList.add(this.build(catalogView));
        }
        return catalogList;
    }
}

