/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.dto.geojson.Geojson;
import cn.gtmap.gtc.resource.domain.resource.dto.resource.CapableView;
import cn.gtmap.gtc.resource.domain.resource.dto.resource.CatalogView;
import cn.gtmap.gtc.resource.domain.resource.dto.resource.ResourceLayer;
import cn.gtmap.gtc.resource.domain.resource.dto.resource.ResourceRefView;
import cn.gtmap.gtc.resource.domain.resource.dto.resource.ResourceView;
import cn.gtmap.gtc.resource.domain.resource.dto.resource.SpatialCoverageProperty;
import cn.gtmap.gtc.resource.domain.resource.metadata.Capable;
import cn.gtmap.gtc.resource.domain.resource.metadata.MIMEType;
import cn.gtmap.gtc.resource.domain.resource.metadata.ManageMatadata;
import cn.gtmap.gtc.resource.domain.resource.metadata.Resource;
import cn.gtmap.gtc.resource.domain.resource.metadata.ResourceApply;
import cn.gtmap.gtc.resource.domain.resource.metadata.SpatialCoverageRef;
import cn.gtmap.gtc.resource.domain.workflow.HistoricTaskDesc;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping(value={"/resource"})
public interface ResourceClient {
    @RequestMapping(value={"/register"})
    public String register();

    @PostMapping(value={"/save"})
    public String saveResource(@RequestBody ResourceView var1);

    @PostMapping(value={"/saveMultiResource"})
    public String saveMultiResource(@RequestBody ResourceView var1);

    @PostMapping(value={"/update"})
    public String updateResource(@RequestBody ResourceView var1);

    @RequestMapping(value={"/deleteResource/{id}"})
    public Boolean deleteResource(@PathVariable(name="id") String var1);

    @RequestMapping(value={"/deleteResourceRef/{id}"})
    public Map deleteResourceRef(@PathVariable(name="id") String var1);

    @RequestMapping(value={"/deleteResourceCapables/{id}"})
    public Boolean deleteResourceCapables(@PathVariable(name="id") String var1);

    @PostMapping(value={"/apply"})
    public Boolean applyResource(ResourceApply var1);

    @RequestMapping(value={"/transfer/task/{taskId}"})
    public String transferProcess(@PathVariable(name="taskId") String var1, @RequestBody ResourceApply var2);

    @RequestMapping(value={"/query/applyData/{taskId}"})
    public ResourceApply queryApply(@PathVariable(name="taskId") String var1);

    @GetMapping(value={"/query/applyData/key/{businessKey}"})
    public ResourceApply queryApplyByKey(@PathVariable(name="businessKey") String var1);

    @PostMapping(value={"/check/apply"})
    public Boolean checkApply(ResourceApply var1);

    @PostMapping(value={"/back/apply"})
    public Boolean backApply(ResourceApply var1);

    @RequestMapping(value={"/find/history/processHistory/{processId}"})
    public List<HistoricTaskDesc> queryProcessHistory(@PathVariable(name="processId") String var1);

    @RequestMapping(value={"/catalog/resources/{catalogId}"})
    public Page<ResourceView> findCatalogResources(@PathVariable(name="catalogId") String var1, Pageable var2);

    @RequestMapping(value={"/getProcessPage"})
    public ResourceView getProcessPage(Pageable var1);

    @RequestMapping(value={"/id/{id}"})
    public ResourceView queryResourceById(@PathVariable(name="id") String var1);

    @RequestMapping(value={"/getSpatialCoverageRefByWkid/{wkid}"})
    public SpatialCoverageRef getSpatialCoverageRefByWkid(@PathVariable(name="wkid") int var1);

    @RequestMapping(value={"/{id}/capables"})
    public List<CapableView> queryResourceCapables(@PathVariable(name="id") String var1);

    @RequestMapping(value={"/{id}/getCapableById"})
    public CapableView getCapableById(@PathVariable(name="id") String var1);

    @RequestMapping(value={"/{id}/getResourceByCapable"})
    public ResourceView getResourceByCapable(@PathVariable(name="id") String var1);

    @RequestMapping(value={"/{id}/ResourceRights"})
    public Boolean getRightsByResource(@PathVariable(name="id") String var1);

    @RequestMapping(value={"/{id}/getRateById"})
    public int getRateById(@PathVariable(name="id") String var1);

    @RequestMapping(value={"/{id}/getResourceRef"})
    public List<ResourceRefView> getResourceRef(@PathVariable(name="id") String var1);

    @RequestMapping(value={"/{id}/capables/original"})
    public List<Capable> queryResourceCapablesOriginal(@PathVariable(name="id") String var1);

    @RequestMapping(value={"/px/{id}/{capableType}/url"})
    public String queryResourceCapableUrls(@PathVariable(name="id") String var1, @PathVariable(name="capableType") String var2);

    @RequestMapping(value={"/query/publisher"})
    public Page<ResourceView> queryResourceByPublisher(@RequestParam(name="keyword", required=false) String var1, Pageable var2);

    @RequestMapping(value={"/query/type/{type}"})
    public Page<ResourceView> queryResourcesByType(@PathVariable(name="type") String var1, Pageable var2);

    @RequestMapping(value={"/query/spatialCoverage"})
    public List<ResourceView> queryResourcesBySpatialCoverage(@RequestBody SpatialCoverageProperty var1);

    @PostMapping(value={"/query/condition"})
    public Page<ResourceView> queryResourceByCondition(@RequestParam(name="keyword", required=false) String var1, @RequestParam(name="title", required=false) String var2, @RequestParam(name="start", required=false) Date var3, @RequestParam(name="end", required=false) Date var4, Pageable var5);

    @PostMapping(value={"/query/queryResourceByTitle"})
    public List<ResourceView> queryResourceByTitle(@RequestParam(name="title", required=false) String var1);

    @RequestMapping(value={"/query/all"})
    public Page<ResourceView> findResources(Pageable var1);

    @RequestMapping(value={"capable/all"})
    public List<MIMEType> findAllCapableType();

    @RequestMapping(value={"capable/{name}"})
    public MIMEType findCapableType(@PathVariable(name="name") String var1);

    @GetMapping(value={"/query/queryApplyById/{id}"})
    public ResourceApply queryApplyById(@PathVariable(name="id") String var1);

    @RequestMapping(value={"/query/condition2"})
    public List<ResourceView> condition2(@RequestParam(name="catalog", required=false) String var1, @RequestParam(name="type", required=false) String var2, @RequestParam(name="region", required=false) String var3);

    @RequestMapping(value={"/history/process/unchecked"})
    public Page<ResourceApply> applyIsendAndUnCheck(@RequestParam(name="keyword", required=false) String var1, Pageable var2);

    @RequestMapping(value={"/history/process/checked"})
    public Page<ResourceApply> applyIsendAndChecked(@RequestParam(name="keyword", required=false) String var1, Pageable var2);

    @RequestMapping(value={"/history/process/turnBack"})
    public Page<ResourceApply> applyTurnBack(@RequestParam(name="keyword", required=false) String var1, Pageable var2);

    @RequestMapping(value={"/query/active/tasks/undo"})
    public Page<ResourceApply> applyINeedCheck(@RequestParam(name="keyword", required=false) String var1, Pageable var2);

    @RequestMapping(value={"/query/active/tasks"})
    public Page<ResourceApply> applyIChecked(@RequestParam(name="keyword", required=false) String var1, Pageable var2);

    @PostMapping(value={"/query/condition2/pageable"})
    public Page<ResourceView> queryPageResourceByCondition2(@RequestParam(name="catalog", required=false) String var1, @RequestParam(name="type", required=false) String var2, @RequestParam(name="region", required=false) String var3, @RequestParam(name="keyword", required=false) String var4, @RequestParam(name="wkid", required=false) Integer var5, @RequestParam(name="fwlx", required=false) String var6, Pageable var7);

    @PostMapping(value={"/query/condition3/pageable"})
    public Page<ResourceView> queryPageResourceByCondition3(@RequestParam(name="catalog", required=false) String var1, @RequestParam(name="type", required=false) String var2, @RequestParam(name="region", required=false) String var3, @RequestParam(name="keyword", required=false) String var4, @RequestParam(name="wkid", required=false) Integer var5, @RequestParam(name="fwlx", required=false) String var6, Pageable var7);

    @PostMapping(value={"/query/condition4/pageable"})
    public Page<ResourceView> queryPageResourceByCondition4(@RequestParam(name="catalog", required=false) String var1, @RequestParam(name="department", required=false) String var2, @RequestParam(name="type", required=false) String var3, @RequestParam(name="region", required=false) String var4, @RequestParam(name="keyword", required=false) String var5, @RequestParam(name="wkid", required=false) Integer var6, @RequestParam(name="fwlx", required=false) String var7, @RequestParam(name="dataResource", required=false) String var8, Pageable var9);

    @RequestMapping(value={"/grantAthority"})
    public Boolean grantAthority(@RequestParam(name="user", required=false) String var1, @RequestParam(name="role", required=false) String var2, @RequestParam(name="departments", required=false) String var3, @RequestParam(name="resourceId", required=false) String var4, @RequestParam(name="capable", required=false) String var5);

    @RequestMapping(value={"/backAthority"})
    public Boolean backAthority(@RequestParam(name="id", required=false) String var1);

    @RequestMapping(value={"/query/getSpatialCoverageRefList"})
    public List<SpatialCoverageRef> getSpatialCoverageRefList();

    @PostMapping(value={"/query/queryMapResourceByCondition"})
    public Page<ResourceLayer> queryMapResourceByCondition(@RequestParam(name="keyword", required=false) String var1, @RequestParam(name="catalogId", required=false) String var2, @RequestParam(name="type", required=false) String var3, Pageable var4);

    @RequestMapping(value={"/findCapableByResId"})
    public List<CapableView> findCapableByResId(@RequestParam(name="id") String var1);

    @GetMapping(value={"/query/synIsResgisteredByUrl"})
    public List<Boolean> synIsResgisteredByUrl(@RequestParam(name="urls") String var1);

    @PostMapping(value={"/synResources"})
    public List<CatalogView> synResources(@RequestBody ResourceView[] var1);

    @PostMapping(value={"/save/manageMatadata"})
    public boolean saveManageMatadata(@RequestBody ManageMatadata var1);

    @PostMapping(value={"/update/manageMatadata"})
    public boolean updateMatadata(@RequestBody ManageMatadata var1);

    @RequestMapping(value={"/del/manageMatadata"})
    public boolean delManageMatadata(@RequestParam(name="ids", required=true) String var1);

    @GetMapping(value={"/query/manageMatadatas"})
    public List<ManageMatadata> queryManageMatadatas(@RequestParam(name="condition", required=true) String var1);

    @GetMapping(value={"/queryResByIds"})
    public List<Resource> queryResByIds(@RequestParam(name="ids") String var1);

    @GetMapping(value={"/findAll/manageMatadatas"})
    public List<ManageMatadata> findAllManagemataData();

    @PostMapping(value={"/saveResLogParam"})
    public String saveResLogParam(@RequestBody Map var1);

    @PostMapping(value={"/saveGeoJson"})
    public Map saveGeoJson(@RequestBody Map var1);

    @RequestMapping(value={"/queryByServiceId"})
    public Geojson queryByServiceId(@RequestParam(name="serviceId", required=false) String var1);

    @GetMapping(value={"/query/alllist"})
    public List<String[]> findAllEnabled();

    @GetMapping(value={"/queryResById"})
    public Resource queryResById(@RequestParam(name="id") String var1);

    @GetMapping(value={"/getNewestRes"})
    public List<Resource> getNewestRes(@RequestParam(name="size", required=false, defaultValue="5") int var1);

    @GetMapping(value={"/getResourceCount"})
    public Long getResourceCount();

    @GetMapping(value={"/getResByCreatorName"})
    public List<String> findResByCreatorIn(@RequestParam(name="creators") List<String> var1);

    @GetMapping(value={"/getTitleById"})
    public String getTitleById(@RequestParam(name="id") String var1);
}

