/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.config.response.ResponseData;
import cn.gtmap.gtc.resource.domain.resource.dto.resource.CatalogView;
import cn.gtmap.gtc.resource.domain.resource.dto.tpl.Tpl;
import cn.gtmap.gtc.resource.domain.resource.metadata.Catalog;
import cn.gtmap.gtc.resource.domain.resource.metadata.CatalogDto;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping(value={"/catalog"})
public interface CatalogClient {
    @RequestMapping(value={"/query/root/{type}"})
    public List<CatalogView> findRootCatalog(@PathVariable(name="type") String var1);

    @RequestMapping(value={"/default/root"})
    public List<CatalogView> findRootCatalog();

    @GetMapping(value={"/root/groups"})
    public Map findRootCatalogGroups();

    @GetMapping(value={"/root/getDataDownloadCatalogGroups"})
    public Map getDataDownloadCatalogGroups();

    @RequestMapping(value={"/query/{id}/children"})
    public List<CatalogView> findChildCatalog(@PathVariable(name="id") String var1);

    @GetMapping(value={"/query/children/{parentId}"})
    public List<CatalogView> findByParentId(@PathVariable(name="parentId") String var1);

    @RequestMapping(value={"/query/type/{type}"})
    public List<Catalog> findCatalogByType(@PathVariable(name="type") String var1);

    @RequestMapping(value={"/query/id/{id}"})
    public Catalog findCatalogById(@PathVariable(name="id") String var1);

    @RequestMapping(value={"/query/findAllCatalogByType/{type}"})
    public List<CatalogView> findAllCatalogByType(@PathVariable(name="type") String var1);

    @RequestMapping(value={"/query/findAllResourceType"})
    public List<CatalogView> findAllResourceType(@RequestParam(name="type") String var1);

    @GetMapping(value={"/query/findParentByChild/{id}"})
    public List findParentByChild(@PathVariable(name="id") String var1);

    @PostMapping(value={"/saveCatalog"})
    public Catalog saveCatalog(@RequestBody Catalog var1);

    @PostMapping(value={"/saveCatalogParams"})
    public Catalog saveCatalogParams(@RequestBody Map var1);

    @RequestMapping(value={"/deleteCatalog/{id}"})
    public void deleteCatalog(@PathVariable(name="id") String var1);

    @RequestMapping(value={"/deleteCatalogByType/{type}"})
    public void deleteCatalogByType(@PathVariable(name="type") String var1);

    @RequestMapping(value={"/deleteRef/{id}"})
    public void deleteRef(@PathVariable(name="id") String var1);

    @GetMapping(value={"/findAllRootCatalog/{parentId}"})
    public List<Catalog> findAllRootCatalog(@PathVariable(name="parentId") String var1);

    @GetMapping(value={"/findAllRootCatalogAndTotal/{type}/{parentId}"})
    public List<CatalogDto> findAllRootCatalogAndTotal(@PathVariable(name="type") String var1, @PathVariable(name="parentId") String var2);

    @GetMapping(value={"/findCatRefList/{id}"})
    public List<String> findCatRefList(@PathVariable(name="id") String var1);

    @RequestMapping(value={"/associate/catalogAndResource"})
    public Catalog associateCatalogAndResources(@RequestParam(name="catalogId") String var1, @RequestParam(name="resources") String var2, @RequestParam(name="replaceAll", required=false) boolean var3);

    @RequestMapping(value={"/updateCatalog"})
    public Catalog updateCatalog(@RequestParam(name="nodeArr") String var1, @RequestParam(name="type") String var2);

    @RequestMapping(value={"/remove/resource/ref"})
    public Catalog removeCatalogAndResources(@RequestParam(name="catalogId") String var1, @RequestParam(name="resources") String var2);

    @GetMapping(value={"/sourcesCount"})
    public Map<String, Integer> getSourcesCountByType();

    @GetMapping(value={"/findCatalogIdsByIds/{catalogIds}"})
    public List<Catalog> findCatalogIdsByIds(@PathVariable(name="catalogIds") String var1);

    @PostMapping(value={"/copyCatalogs"})
    public Object copyCatalogs(@RequestBody Map var1);

    @RequestMapping(value={"/saveCatalogAndTplRef"})
    public Object saveCatTplRef(@RequestParam(name="catalogId", required=false) String var1, @RequestParam(name="tplIds", required=false) String var2, @RequestParam(name="replace", required=false) boolean var3);

    @RequestMapping(value={"/findTplsByCatalogId"})
    public List<Tpl> findTplsByCatalogId(@RequestParam(name="catalogId", required=false) String var1);

    @RequestMapping(value={"/findCatalogsByTplId"})
    public List<Catalog> findCatalogsByTplId(@RequestParam(name="tplId", required=false) String var1);

    @RequestMapping(value={"/queryCatalogs"})
    public List<Catalog> queryCatalogs(@RequestParam(name="catTypes", required=false) String var1);

    @RequestMapping(value={"/handleCatResData"})
    public boolean handleCatResData();

    @RequestMapping(value={"/buildJSONTree"})
    public String buildJSONTree(@RequestParam(name="type", required=false) String var1);

    @RequestMapping(value={"/buildJSONTreeByRole"})
    public String buildJSONTreeByRole(@RequestParam(name="type", required=false) String var1, @RequestParam(name="roleId", required=false) String var2);

    @GetMapping(value={"/queryRootCatalogByType/{type}"})
    public Catalog queryRootCatalogByType(@PathVariable(name="type") String var1);

    @GetMapping(value={"/getResTypeAppendAttr"})
    public ResponseData getResTypeAppendAttr(@RequestParam(value="type") String var1);

    @GetMapping(value={"/getCountByPidAndType"})
    public Boolean getCountByPidAndType(@RequestParam(value="type") String var1);
}

