/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.clients.dev;

import cn.gtmap.gtc.resource.domain.dev.Article;
import cn.gtmap.gtc.resource.domain.dev.Comment;
import cn.gtmap.gtc.resource.domain.dev.Index;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="${app.services.dev:dev}")
@RequestMapping(value={"/dev/data/"})
public interface DevDataClient {
    @PostMapping(value={"add/article"})
    public String addArticle(@RequestBody Article var1);

    @PostMapping(value={"search/article"})
    public Article searchArticle(@RequestParam(value="id") String var1);

    @PostMapping(value={"search/category"})
    public Page<Article> searchArticleByCategoryId(@RequestParam(value="id") String var1, Pageable var2);

    @PostMapping(value={"add/comment"})
    public String addComment(@RequestBody Comment var1);

    @PostMapping(value={"search/comment/id"})
    public Comment searchComment(@RequestParam(value="id") String var1);

    @PostMapping(value={"search/comment/articleid"})
    public Page<Comment> searchCommentByArticleId(@RequestParam(value="articleId") String var1, Pageable var2);

    @PostMapping(value={"search/comment/commentid"})
    public Page<Comment> searchCommentByCommentId(@RequestParam(value="commentId") String var1, Pageable var2);

    @PostMapping(value={"delete/comment"})
    public void deleteCommentById(@RequestParam(value="commentId") String var1);

    @PostMapping(value={"delete/article"})
    public void deleteArticleById(@RequestParam(value="articleId") String var1);

    @PostMapping(value={"update/article"})
    public void updateArticleById(@RequestBody Article var1);

    @PostMapping(value={"update/comment"})
    public void updateComment(@RequestBody Comment var1);

    @PostMapping(value={"search/index/article"})
    public List<Article> getArticleByCatgoryId(@RequestParam(value="categoryid") String var1);

    @PostMapping(value={"search/article/fuzz"})
    public Page<Article> getArticleFuzz(@RequestParam(value="query") String var1, Pageable var2);

    @PostMapping(value={"get/index"})
    public List<Index> getParentIndex();

    @PostMapping(value={"add/index"})
    public String addIndex(@RequestBody Index var1);

    @PostMapping(value={"update/index"})
    public boolean updateIndex(@RequestBody Index var1);

    @PostMapping(value={"get/parentid"})
    public List<Index> getParentIdIndex(@RequestParam(value="parentId") String var1);

    @PostMapping(value={"delete/index"})
    public boolean deleteIndex(@RequestParam(value="indexId") String var1);

    @PostMapping(value={"get/indexId"})
    public Index getIndxById(@RequestParam(value="indexId") String var1);
}

