/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.clients;

import cn.gtmap.gtc.resource.ex.DiscoverClientNotFoundException;
import java.net.URI;
import java.util.Optional;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class Clients {
    private DiscoveryClient discoveryClient;

    public Clients(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    public ServiceInstance getRandomServiceInstanceById(String appId) {
        Optional optional;
        if (this.discoveryClient != null && this.discoveryClient.getServices().stream().anyMatch(s -> s.equals(appId)) && (optional = this.discoveryClient.getInstances(appId).stream().findAny()).isPresent()) {
            return (ServiceInstance)optional.get();
        }
        throw new DiscoverClientNotFoundException(appId);
    }

    public URI getRandomServiceURI(String appId) {
        return this.getRandomServiceInstanceById(appId).getUri();
    }
}

