package cn.gtmap.gtc.resource.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import static cn.gtmap.gtc.resource.Constant.DEFAULT_DATE_FORMATE;

/**
 * Created by Administrator on 2017/12/15.
 */
public class TimeUtil {

    private static final Logger logger = LoggerFactory.getLogger(TimeUtil.class);

    /**
     * 得到几天前的时间
     *
     * @param d
     * @param day
     * @return
     */
    public static Date getDateBefore(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(Calendar.DATE, now.get(Calendar.DATE) - day);
        return now.getTime();
    }


    public static Date getMonday(Date d){
        Calendar cld = Calendar.getInstance();
        cld.setTime(d);
        cld.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);//周一
        return cld.getTime();
    }


    public static Date getMonthFirstDay(Date d){
        Calendar cld = Calendar.getInstance();
        cld.setTime(d);
        cld.set(Calendar.DAY_OF_MONTH, 1);//周一
        return cld.getTime();
    }

    public static Long getDateBefore(Date date, String timeType) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        long start = 0;
        if ("day".equals(timeType)){
            c.add(Calendar.DATE, - 6);
            start = c.getTimeInMillis();
        }else if ("week".equals(timeType)){
            c.add(Calendar.MONTH, -1);
            start = c.getTimeInMillis();
        } else if ("month".equals(timeType)){
            c.add(Calendar.YEAR, -1);
            start = c.getTimeInMillis();
        }

        return start;
    }

    public static Long getDateBeforePro(Date date, String timeType) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        long start = 0;
        if ("day".equals(timeType)){
            c.add(Calendar.HOUR, - 24);
            start = c.getTimeInMillis();
        }else if ("week".equals(timeType)){
            c.add(Calendar.DATE, -6);
            start = c.getTimeInMillis();
        } else if ("month".equals(timeType)){
            c.add(Calendar.MONTH, -1);
            start = c.getTimeInMillis();
        }
        return start;
    }

    public static String getDateBeforeStr(Date date, String timeType) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        c.setTime(date);
        String start = "";
        if ("day".equals(timeType)){
            c.add(Calendar.HOUR, - 24);
            start = sdf.format(c.getTime());
        }else if ("week".equals(timeType)){
            c.add(Calendar.DATE, -6);
            start = sdf.format(c.getTime());
        } else if ("month".equals(timeType)){
            c.add(Calendar.MONTH, -1);
            start = sdf.format(c.getTime());
        } else if("year".equals(timeType)){
            c.add(Calendar.YEAR, -1);
            start = sdf.format(c.getTime());
        }
        return start;
    }

    public static  Date getAfterMonth(Date date, int count){
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(Calendar.MONTH, count);
        return c.getTime();
    }

    /**
     * @param
     * @return
     */
    public static Date getBegin(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        return new Date(sdf.format(date) + " 00:00:00");
    }

    public static Date getEnd(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        return new Date(sdf.format(date) + " 23:59:59");
    }

    /**
     * 得到几天后的时间
     *
     * @param d
     * @param day
     * @return
     */
    public static Date getDateAfter(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(Calendar.DATE, now.get(Calendar.DATE) + day);
        return now.getTime();
    }

    private int isYeaterday(Date oldTime, Date newTime) throws ParseException {
        if (newTime == null) {
            newTime = new Date();
        }
        //将下面的 理解成  yyyy-MM-dd 00：00：00 更好理解点
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATE_FORMATE);
        String todayStr = format.format(newTime);
        Date today = format.parse(todayStr);
        //昨天 86400000=24*60*60*1000 一天
        if ((today.getTime() - oldTime.getTime()) > 0 && (today.getTime() - oldTime.getTime()) <= 86400000) {
            return 0;
        } else if ((today.getTime() - oldTime.getTime()) <= 0) { //至少是今天
            return -1;
        } else { //至少是前天
            return 1;
        }

    }

    private boolean isToday(Date time) {
        try {
            Date nowTime = new Date();
            SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATE_FORMATE);
            String todayStr = format.format(nowTime);
            Date today = format.parse(todayStr);
            long starttime = today.getTime();
            long endtime = today.getTime() + 86400000;
            if (starttime <= time.getTime() && time.getTime() <= endtime) {
                return true;
            }
        } catch (Exception e) {
            logger.error("日期转换错误", e);
        }
        return false;
    }
}
