package cn.gtmap.gtc.resource.utils;

import org.apache.commons.collections.MapUtils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;

public class MathUtil {
    /**
     * Double 相加
     *
     * @return Double
     * @应用
     */
    public static Double doubleAdd(Double v1, Double v2) {
        BigDecimal b1 = new BigDecimal(v1.toString());
        BigDecimal b2 = new BigDecimal(v2.toString());
        return new Double(b1.add(b2).doubleValue());
    }

    /**
     * String 相加
     *
     * @param v1
     * @param v2
     * @return
     */
    public static String stringAdd(String v1, String v2) {
        return new BigInteger(v1).add(new BigInteger(v2)).toString();
    }


    /**
     * Double 相加
     *
     * @return Double
     * @应用
     */
    public static Double doubleAddThree(Double v1, Double v2, Double v3) {
        BigDecimal b1 = new BigDecimal(v1.toString());
        BigDecimal b2 = new BigDecimal(v2.toString());
        BigDecimal b3 = new BigDecimal(v3.toString());
        Double add1 = new Double(b1.add(b2).doubleValue());
        BigDecimal addB1 = new BigDecimal(add1.toString());
        return new Double(addB1.add(b3).doubleValue());
    }

    /**
     * double 相减
     *
     * @param d1
     * @param d2
     * @return
     */
    public static double sub(double d1, double d2) {
        BigDecimal bd1 = new BigDecimal(Double.toString(d1));
        BigDecimal bd2 = new BigDecimal(Double.toString(d2));
        return bd1.subtract(bd2).doubleValue();
    }

    /**
     * double 乘法
     *
     * @param d1
     * @param d2
     * @return
     */
    public static double mul(double d1, double d2) {
        BigDecimal bd1 = new BigDecimal(Double.toString(d1));
        BigDecimal bd2 = new BigDecimal(Double.toString(d2));
        return bd1.multiply(bd2).doubleValue();
    }


    /**
     * double 除法
     *
     * @param d1
     * @param d2
     * @param scale 四舍五入 小数点位数
     * @return
     */
    public static double div(double d1, double d2, int scale) {
        //  当然在此之前，你要判断分母是否为0，
        //  为0你可以根据实际需求做相应的处理
        BigDecimal bd1 = new BigDecimal(Double.toString(d1));
        BigDecimal bd2 = new BigDecimal(Double.toString(d2));
        return bd1.divide(bd2, scale, BigDecimal.ROUND_HALF_UP).doubleValue();
    }

    /***
     *list 对某个字段进行求和
     *
     * @param list
     * @return
     */
    public static double getSumAreaByList(List<Map> list, String key) {
        double sum = 0;
        if (list != null && list.size() > 0) {
            for (Map map : list) {
                sum += MapUtils.getDoubleValue(map, key, 0.0);
            }
        }
        return sum;
    }


    /**
     * 四舍五入保存小数位数
     *
     * @param d1 数字
     * @param i  保留几位小数
     * @return
     */
    public static BigDecimal rounding(double d1, int i) {
        BigDecimal bg = new BigDecimal(d1);
        return bg.setScale(i, BigDecimal.ROUND_HALF_UP);
    }
}
