package cn.gtmap.gtc.resource.utils;

import cn.gtmap.gtc.gis.support.Document;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.context.MessageSource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * @author gt-weiran
 * @date 2020-09-09-14:15
 * version
 * illustration 此工具类用于自定义模板生成Excel文件数据
 */
public class ExcelComInitUtils {

    protected static final String RES = "result";

    public static MessageSource message;


    /**
     * 获取message
     *
     * @param key
     * @param param
     * @return
     */
    public static String getMessage(String key, Object... param) {
        try {
            return message.getMessage(key, param, Locale.getDefault());
        } catch (Exception ex) {
            return key;
        }
    }


    /**
     * result map
     *
     * @param value
     * @return
     */
    public static Map<String, Object> result(Object value) {
        Map<String, Object> result = new HashMap<>();
        result.put(RES, value);
        return result;
    }

    /**
     * 生成Excel自定义分析模板
     *
     * @param tableHead 简单行表头
     * @param data 数据内容
     * @param tplName 导出Excel文件名称
     * @return Document
     */
    public static Document writeComAnalyExcel(List tableHead, Map<String, List> data, String tplName) {
        Document document;
        document = Document.getDocByName(tplName);
        Workbook workbook = new XSSFWorkbook();
        try (//创建excel
             ByteArrayOutputStream out = new ByteArrayOutputStream();) {
            Font blackFont = workbook.createFont();
            blackFont.setFontName("宋体");
            // 样式对象-表头样式
            CellStyle blackFontStyle = workbook.createCellStyle();
            blackFontStyle.setFont(blackFont);
            blackFontStyle.setVerticalAlignment(CellStyle.ALIGN_CENTER);
            blackFontStyle.setAlignment(CellStyle.ALIGN_CENTER);
            //设置字体大小
            blackFont.setFontHeightInPoints((short) 11);
            blackFont.setBoldweight(Font.BOLDWEIGHT_BOLD);

            for (String sheetName : data.keySet()) {
                Sheet sheet = workbook.createSheet(sheetName);
                sheet.setDefaultColumnWidth(15);
                //设置table header
                Row row;
                //设置table value
                List<List> values = data.get(sheetName);
                for (int rowIndex = 0; rowIndex < values.size() + 1; rowIndex++) {
                    row = sheet.createRow(rowIndex);
                    if (rowIndex == 0) {
                        //对表头进行修饰
                        addCols(row, tableHead, blackFontStyle);
                    } else {
                        List value = values.get(rowIndex - 1);
                        addCols(row, value,null);
                    }
                }

            }
            workbook.write(out);
            document.setContent(out.toByteArray());
        } catch (IOException e) {
            throw new RuntimeException(getMessage("doc.out.stream.error", e.getLocalizedMessage()));
        }
        return document;
    }

    private static void addCols(Row row, List<String> valueList, CellStyle cellStyle) {
        for (int i = 0; i < valueList.size(); i++) {
            Cell cell = row.createCell(i);
            cell.setCellValue(valueList.get(i));
            if (cellStyle != null) {
                cell.setCellStyle(cellStyle);
            }
        }
    }
}

