package cn.gtmap.gtc.resource.support.hibernate.type.json;

import cn.gtmap.gtc.resource.support.hibernate.type.json.internal.JsonBinarySqlTypeDescriptor;
import cn.gtmap.gtc.resource.support.hibernate.type.json.internal.JsonNodeTypeDescriptor;
import com.fasterxml.jackson.databind.JsonNode;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;

/**
 * Maps a Jackson {@link JsonNode} on a binary JSON column type.
 * <p>
 *
 * @author Vlad Mihalcea
 */
public class JsonNodeBinaryType
        extends AbstractSingleColumnStandardBasicType<JsonNode> {

    public static final JsonNodeBinaryType INSTANCE = new JsonNodeBinaryType();
    
    public JsonNodeBinaryType() {
        super(JsonBinarySqlTypeDescriptor.INSTANCE, JsonNodeTypeDescriptor.INSTANCE);
    }

    public String getName() {
        return "jsonb-node";
    }
}