package cn.gtmap.gtc.resource.domain.server;

import cn.gtmap.gtc.resource.domain.BaseEntity;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 1 * @Author: zgl
 * 2 * @Date: 2019/12/11 17:00
 * 3
 */
@Entity
@Table(name = "gt_server_status_his")
public class ServerStatusHis extends BaseEntity {

    /**
     * 服务id
     */
    private String serverId;
    /**
     * 服务类型
     * 其他：0
     * 服务器主机资源监控：1
     * 微服务监控：2
     * 地图服务监控：3
     */
    private String serverType;

    /**
     * 服务内容
     */
    private String serverContent;

    /**
     * 服务标题
     */
    private String serverTitle;

    /**
     * 服务状态
     * 其他：0
     * 正常：1
     * 异常：2
     * 警告：3
     * 停用：4
     */
    private String serverStatus;

    /**
     * 备注
     */
    private String remark;

    public String getServerId() {
        return serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getServerType() {
        return serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getServerContent() {
        return serverContent;
    }

    public void setServerContent(String serverContent) {
        this.serverContent = serverContent;
    }

    public String getServerTitle() {
        return serverTitle;
    }

    public void setServerTitle(String serverTitle) {
        this.serverTitle = serverTitle;
    }

    public String getServerStatus() {
        return serverStatus;
    }

    public void setServerStatus(String serverStatus) {
        this.serverStatus = serverStatus;
    }


    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
