package cn.gtmap.gtc.resource.domain.resource.metadata.source;

import cn.gtmap.gtc.resource.domain.core.Title;
import cn.gtmap.gtc.resource.domain.core.Type;

/**
 * .MapServiceType
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/11/9 18:57
 */
public enum SpatialServiceType implements Title, Type {

    // ArcGIS
    AGS_REST("ArcGIS动态服务"),
    AGS_TILE("ArcGIS静态切片"),
    AGS_FEATURE("ArcGIS要素服务"),
    AGS_VECTOR_TILE("ArcGIS矢量切片服务"),
    // OGC
    WMS("WMS服务"),
    WFS("WFS服务"),
    WCS("WCS服务"),
    WFS_T("WFS-T服务"),
    WMTS("WMTS服务"),
    WPS("WPS服务"),
    GEO_PROCESS("GEO_PROCESS服务"),
    CSW("CSW服务"),
    GML("地理标记语言"),
    KML("KML"),
    MERGE("MERGE聚合服务"),
    SPLIT("SPLIT拆分服务"),
    //
    VECTOR_TILE("VT矢量切片"),
    GEOJSON("GeoJSON");

    private String title;

    SpatialServiceType(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return title;
    }

    @Override
    public String getType() {
        return this.name();
    }
}
