package cn.gtmap.gtc.resource.domain.resource.metadata.source;

import cn.gtmap.gtc.resource.domain.core.Title;
import cn.gtmap.gtc.resource.domain.core.Type;

/**
 * .DocumentType
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/11/9 20:04
 */
public enum DocumentType implements Title, Type {

    PPT("PowerPoint文件"),
    WORD("Word文件"),
    PDF("PDF文件"),
    EXCEL("Excel文件"),
    CSV("CSV文件"),
    XML("XML文件"),
    HTML("HTML文件"),
    TXT("TXT文件"),
    PNG("PNG图片"),
    JPG("JPG图片"),
    TFF("TTF图片"),
    BMP("BMP图片");

    private String title;

    DocumentType(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }


    @Override
    public String getType() {
        return this.name();
    }
}
