package cn.gtmap.gtc.resource.domain.resource.metadata.display;

import cn.gtmap.gtc.resource.domain.ID;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * .展示中心
 *
 * @author 杨红杰
 * @version V1.0, 2018/01/17
 */
@Entity
@Table(name = "gt_display_center")
public class DisplayCenter extends ID {
    /**
     * 业务
     */
    private String business;
    /**
     * 图片
     */
    private String pic;
    /**
     * 标题
     */
    private String title;
    /**
     * 详情
     */
    private String detail;
    /**
     * 类型
     */
    private String type;
    /**
     * 路由
     */
    private String route;
    /**
     * 资源显示位置（1：左侧；2：右侧）
     */
    private String resPosition;
    /**
     * 资源类型（0：动态服务；1：切片服务；2：图件；3：pdf；4：其他（iframe））
     */
    private String resType;
    /**
     * 资源信息
     */
    private String resInfo;

    /**
     * 目录点击效果（1：展开；0：查询）

     */
    private Boolean catMode;

    /**
     * 点击查看按钮是否可展示
     */
    private Boolean displayMode;

    /*
    * 按钮样式
    * */
    private String style;


    /**
     * 排序
     */
    private Integer sort;

    /**
     * 图件数据:xmlData
     */

    private String xmlData;

    /**
     * 父名称
     */
    private String parent;

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public String getPic() {
        return pic;
    }

    public void setPic(String pic) {
        this.pic = pic;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRoute() {
        return route;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public String getResPosition() {
        return resPosition;
    }

    public void setResPosition(String resPosition) {
        this.resPosition = resPosition;
    }

    public String getResType() {
        return resType;
    }

    public void setResType(String resType) {
        this.resType = resType;
    }

    public String getResInfo() {
        return resInfo;
    }

    public void setResInfo(String resInfo) {
        this.resInfo = resInfo;
    }

    public Boolean getCatMode() {
        return catMode;
    }

    public void setCatMode(Boolean catMode) {
        this.catMode = catMode;
    }


    public Boolean getDisplayMode() {
        return displayMode;
    }

    public void setDisplayMode(Boolean displayMode) {
        this.displayMode = displayMode;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getStyle() {
        return style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getXmlData() {
        return xmlData;
    }

    public void setXmlData(String xmlData) {
        this.xmlData = xmlData;
    }

    public String getParent() {
        return parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }
}
