package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Id;
import javax.persistence.GeneratedValue;
import java.io.Serializable;
import java.util.Date;

/**
 * @Description
 * @Author  wzt
 * @Date 2021-04-29 09:08:02
 */

@Entity
@Table ( name ="gt_service" , schema = "")
public class Services extends BaseEntity implements Serializable {

	private static final long serialVersionUID =  4028012943075885278L;
	/**
	 * 服务描述
	 */
	@Column(name = "res_description" )
	private String resDescription;

	/**
	 * 服务类型（Rest/WMS），发布服务时所选
	 */
	@Column(name = "format" )
	private String format;

	/**
	 * 缩略图（可看已发布服务的缩略图）
	 */
	@Column(name = "icon" )
	private String icon;

	/**
	 * 发布者
	 */
	@Column(name = "publisher" )
	private String publisher;

	/**
	 * 工作空间路径（服务器）
	 */
	@Column(name = "workspace_resource" )
	private String workspaceResource;

	/**
	 * 服务数据源（工作空间）类型（文件型、ORACLE工作空间等）
	 */
	@Column(name = "data_type" )
	private String dataType;

	/**
	 * 原始数据路径（zip）
	 */
	@Column(name = "zip_resource" )
	private String zipResource;

	/**
	 * 服务名称
	 */
	@Column(name = "name" )
	private String name;

	/**
	 * 服务别名
	 */
	@Column(name = "alias" )
	private String alias;

	/**
	 * 服务类别（服务目录树中的标签）
	 */
	@Column(name = "type" )
	private String type;

	/**
	 * 年份
	 */
	@Column(name = "year" )
	private String year;

	/**
	 * 服务地址
	 */
	@Column(name = "url" )
	private String url;

	/**
	 * 服务是否公开
	 */
	@Column(name = "ispublic" )
	private Boolean ispublic;

	/**
	 * 资源来源：例如本地还是省厅或者部里
	 */
	@Column(name = "data_resource" )
	private String dataResource;

	/**
	 * 对应站点ip表，可以得到站点信息及数据目录
	 */
	@Column(name = "ipport_id" )
	private String ipportId;

	/**
	 * 当前服务组件所使用的服务接口
	 */
	@Column(name = "interface_type" )
	private String interfaceType;

	/**
	 * 服务状态
	 */
	@Column(name = "service_status" )
   	private String serviceStatus;

	public String getResDescription() {
		return this.resDescription;
	}

	public void setResDescription(String resDescription) {
		this.resDescription = resDescription;
	}

	public String getFormat() {
		return this.format;
	}

	public void setFormat(String format) {
		this.format = format;
	}

	public String getIcon() {
		return this.icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public String getPublisher() {
		return this.publisher;
	}

	public void setPublisher(String publisher) {
		this.publisher = publisher;
	}

	public String getWorkspaceResource() {
		return this.workspaceResource;
	}

	public void setWorkspaceResource(String workspaceResource) {
		this.workspaceResource = workspaceResource;
	}

	public String getDataType() {
		return this.dataType;
	}

	public void setDataType(String dataType) {
		this.dataType = dataType;
	}

	public String getZipResource() {
		return this.zipResource;
	}

	public void setZipResource(String zipResource) {
		this.zipResource = zipResource;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getAlias() {
		return this.alias;
	}

	public void setAlias(String alias) {
		this.alias = alias;
	}

	public String getType() {
		return this.type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getYear() {
		return this.year;
	}

	public void setYear(String year) {
		this.year = year;
	}

	public String getUrl() {
		return this.url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public Boolean getIspublic() {
		return this.ispublic;
	}

	public void setIspublic(Boolean ispublic) {
		this.ispublic = ispublic;
	}

	public String getDataResource() {
		return this.dataResource;
	}

	public void setDataResource(String dataResource) {
		this.dataResource = dataResource;
	}

	public String getIpportId() {
		return this.ipportId;
	}

	public void setIpportId(String ipportId) {
		this.ipportId = ipportId;
	}

	public String getInterfaceType() {
		return this.interfaceType;
	}

	public void setInterfaceType(String interfaceType) {
		this.interfaceType = interfaceType;
	}

	public String getServiceStatus() {
		return serviceStatus;
	}

	public void setServiceStatus(String serviceStatus) {
		this.serviceStatus = serviceStatus;
	}

	@Override
	public String toString() {
		return "{" +
				"resDescription='" + resDescription + '\'' +
				"format='" + format + '\'' +
				"icon='" + icon + '\'' +
				"publisher='" + publisher + '\'' +
				"workspaceResource='" + workspaceResource + '\'' +
				"dataType='" + dataType + '\'' +
				"zipResource='" + zipResource + '\'' +
				"name='" + name + '\'' +
				"alias='" + alias + '\'' +
				"type='" + type + '\'' +
				"year='" + year + '\'' +
				"url='" + url + '\'' +
				"ispublic='" + ispublic + '\'' +
				"dataResource='" + dataResource + '\'' +
				"ipportId='" + ipportId + '\'' +
				"interfaceType='" + interfaceType + '\'' +
				'}';
	}

}