package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Id;
import javax.persistence.GeneratedValue;
import java.io.Serializable;

/**
 * @Description  
 * @Author  wzt
 * @Date 2021-04-13 10:26:30 
 */

@Entity
@Table ( name ="gt_service_layer" , schema = "")
public class ServiceLayer extends BaseEntity implements Serializable {

	private static final long serialVersionUID =  2864634238110562065L;

	/**
	 * 模板id
	 */
   	@Column(name = "template_id" )
	private String templateId;

	/**
	 * 图层名称
	 */
   	@Column(name = "layer")
	private String layer;

	/**
	 * 渲染字段名称
	 */
   	@Column(name = "field" )
	private String field;

	/**
	 * 图层绑定的数据源名称
	 */
   	@Column(name = "source" )
	private String source;

	/**
	 * 图层几何类型（point，polyline，region）
	 */
   	@Column(name = "type" )
	private String type;

	public String getTemplateId() {
		return this.templateId;
	}

	public void setTemplateId(String templateId) {
		this.templateId = templateId;
	}

	public String getLayer() {
		return this.layer;
	}

	public void setLayer(String layer) {
		this.layer = layer;
	}

	public String getField() {
		return this.field;
	}

	public void setField(String field) {
		this.field = field;
	}

	public String getSource() {
		return this.source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public String getType() {
		return this.type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Override
	public String toString() {
		return "{" +
					"templateId='" + templateId + '\'' +
					"layer='" + layer + '\'' +
					"field='" + field + '\'' +
					"source='" + source + '\'' +
					"type='" + type + '\'' +
				'}';
	}

}
