package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import javax.persistence.*;
import java.util.Date;

/**
 * @program: resource
 * @description: 发布的服务状态检测记录表
 * @author: JamesWang
 * @create: 2021-04-27
 */
@Entity
@Table(name = "gt_service_check")
public class ServiceCheck<T> extends BaseEntity {

    /**
     * 检测类型
     */
    @Column(name = "check_title", length=512)
    private String checkTitle;

    /**
     * 检测类型
     */
    @Column(name = "check_type")
    private String checkType;

    /**
     * 检测开始时间
     */
    @Column(name = "check_start_at")
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat( pattern="yyyy-MM-dd HH:mm:ss")
    private Date checkStartAt;

    /**
     * 检测结束时间
     */
    @Column(name = "check_end_at")
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat( pattern="yyyy-MM-dd HH:mm:ss")
    private Date checkEndAt;

    /**
     * 检测耗时，单位：毫秒
     */
    @Column(name = "check_duration")
    private Long checkDuration;

    /**
     * 检测资源总量
     */
    @Column(name = "resource_total")
    private int resourceTotal;

    /**
     * 在线资源总量
     */
    @Column(name = "resource_up")
    private int resourceUp;

    /**
     * 不在线资源总量
     */
    @Column(name = "resource_dowm")
    private int resourceDowm;

    /**
     * 在线资源占比
     */
    @Column(name = "resource_up_rate", precision = 5, scale = 2)
    private float resourceUpRate;

    /**
     * 不在线资源占比
     */
    @Column(name = "resource_dowm_rate", precision = 5, scale = 2)
    private float resourceDowmRate;

    /**
     * 调用者
     */
    @Column(name = "caller")
    private String caller;

    @Column(name = "first_check")
    private int firstCheck;

    @Column(name = "second_check")
    private int secondCheck;

    public String getCheckTitle() {
        return checkTitle;
    }

    public void setCheckTitle(String checkTitle) {
        this.checkTitle = checkTitle;
    }

    public String getCheckType() {
        return checkType;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }

    public Date getCheckStartAt() {
        return checkStartAt;
    }

    public void setCheckStartAt(Date checkStartAt) {
        this.checkStartAt = checkStartAt;
    }

    public Date getCheckEndAt() {
        return checkEndAt;
    }

    public void setCheckEndAt(Date checkEndAt) {
        this.checkEndAt = checkEndAt;
    }

    public Long getCheckDuration() {
        return checkDuration;
    }

    public void setCheckDuration(Long checkDuration) {
        this.checkDuration = checkDuration;
    }

    public int getResourceTotal() {
        return resourceTotal;
    }

    public void setResourceTotal(int resourceTotal) {
        this.resourceTotal = resourceTotal;
    }

    public int getResourceUp() {
        return resourceUp;
    }

    public void setResourceUp(int resourceUp) {
        this.resourceUp = resourceUp;
    }

    public int getResourceDowm() {
        return resourceDowm;
    }

    public void setResourceDowm(int resourceDowm) {
        this.resourceDowm = resourceDowm;
    }

    public float getResourceUpRate() {
        return resourceUpRate;
    }

    public void setResourceUpRate(float resourceUpRate) {
        this.resourceUpRate = resourceUpRate;
    }

    public float getResourceDowmRate() {
        return resourceDowmRate;
    }

    public void setResourceDowmRate(float resourceDowmRate) {
        this.resourceDowmRate = resourceDowmRate;
    }

    public String getCaller() {
        return caller;
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }
}
