package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.ID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * Created by zzf on 2019年1月11日.
 */
@Entity
@Table(name = "gt_user_resource")
public class ResourceUserRef extends ID {
    /**
     * id
     */
    @Column(name = "id")
    private String id;

    /**
     * 角色id
     */
    @Column(name = "user_id")
    private String userId;

    /**
     * 资源id
     */
    @Column(name="resource_id")
    private String resourceId;

    /**
     * 资源名称
     */
    @Column(name="resource_name")
    private String resourceName;

    /**
     * 是否是用户的收藏
     */
    @Column(name="is_favorite")
    private Boolean isFavorite;

    /**
     * 是否是默认加载图层
     */
    @Column(name="def_layer")
    private Boolean defLayer;

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getResourceId() {
        return resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Boolean getIsFavorite(){
        return isFavorite;
    }

    public void setIsFavorite(Boolean isFavorite){
        this.isFavorite = isFavorite;
    }

    public Boolean getDefLayer() {
        return defLayer;
    }

    public void setDefLayer(Boolean defLayer) {
        this.defLayer = defLayer;
    }
}
