package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import javax.persistence.*;
import java.util.Date;

/**
 * ResourceStatus
 *
 * @author <a href="mailto:lanxy88@gmail.com">XiePengyuan</a>
 * @version V1.0, 2020/9/21 14:12
 */
@Entity
@Table(name = "gt_resource_status")
public class ResourceStatus<T> extends BaseEntity {

    /**
     * 关联资源
     */
    private Resource resource;

    /**
     * 资源状态
     */
    private ResourceStatusType statusType;

    /**
     * 状态改变时间
     */
    private Date statusChangeAt;

    /**
     * 资源最新检测时间
     */
    private Date latestDetectedAt;

    /**
     * 资源状态描述
     */
    private String statusContent;

    @OneToOne(fetch = FetchType.EAGER,optional = true,mappedBy = "resourceStatus")
    @PrimaryKeyJoinColumn
//    @org.hibernate.annotations.ForeignKey(name = "none")
    public Resource getResource() {
        return resource;
    }
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Column(name = "status")
    @Enumerated(EnumType.STRING)
    public ResourceStatusType getStatusType() {
        return statusType;
    }
    public void setStatusType(ResourceStatusType statusType) {
        this.statusType = statusType;
    }

    @Column(name = "status_change_at")
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat( pattern="yyyy-MM-dd HH:mm:ss")
    public Date getStatusChangeAt() {
        return statusChangeAt;
    }
    public void setStatusChangeAt(Date statusChangeAt) {
        this.statusChangeAt = statusChangeAt;
    }

    @Column(name = "latest_detected_at")
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat( pattern="yyyy-MM-dd HH:mm:ss")
    public Date getLatestDetectedAt() {
        return latestDetectedAt;
    }
    public void setLatestDetectedAt(Date latestDetectedAt) {
        this.latestDetectedAt = latestDetectedAt;
    }

    @Column(name = "status_content")
    public String getStatusContent() {
        return statusContent;
    }
    public void setStatusContent(String statusContent) {
        this.statusContent = statusContent;
    }
}
