package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import javax.persistence.*;
import java.util.Date;

@Entity
@Table(name = "gt_resource_check")
public class ResourceCheck <T> extends BaseEntity {

    /**
     * 检测类型
     */
    private String checkTitle;
    /**
     * 检测类型
     */
    private String checkType;
    /**
     * 检测开始时间
     */
    private Date checkStartAt;
    /**
     * 检测结束时间
     */
    private Date checkEndAt;
    /**
     * 检测耗时，单位：毫秒
     */
    private Long checkDuration;
    /**
     * 检测资源总量
     */
    private int resourceTotal;
    /**
     * 在线资源总量
     */
    private int resourceUp;
    /**
     * 不在线资源总量
     */
    private int resourceDowm;
    /**
     * 在线资源占比
     */
    private float resourceUpRate;
    /**
     * 不在线资源占比
     */
    private float resourceDowmRate;
    /**
     * 调用者
     */
    private String caller;

    @Column(name = "check_title", length=512)
    public String getCheckTitle() {
        return checkTitle;
    }

    public void setCheckTitle(String checkTitle) {
        this.checkTitle = checkTitle;
    }

    @Column(name = "check_type")
    public String getCheckType() {
        return checkType;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }

    @Column(name = "check_start_at")
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat( pattern="yyyy-MM-dd HH:mm:ss")
    public Date getCheckStartAt() {
        return checkStartAt;
    }

    public void setCheckStartAt(Date checkStartAt) {
        this.checkStartAt = checkStartAt;
    }

    @Column(name = "check_end_at")
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat( pattern="yyyy-MM-dd HH:mm:ss")
    public Date getCheckEndAt() {
        return checkEndAt;
    }

    public void setCheckEndAt(Date checkEndAt) {
        this.checkEndAt = checkEndAt;
    }

    @Column(name = "check_duration")
    public Long getCheckDuration() {
        return checkDuration;
    }

    public void setCheckDuration(Long checkDuration) {
        this.checkDuration = checkDuration;
    }

    @Column(name = "resource_total")
    public int getResourceTotal() {
        return resourceTotal;
    }

    public void setResourceTotal(int resourceTotal) {
        this.resourceTotal = resourceTotal;
    }

    @Column(name = "resource_up")
    public int getResourceUp() {
        return resourceUp;
    }

    public void setResourceUp(int resourceUp) {
        this.resourceUp = resourceUp;
    }

    @Column(name = "resource_dowm")
    public int getResourceDowm() {
        return resourceDowm;
    }

    public void setResourceDowm(int resourceDowm) {
        this.resourceDowm = resourceDowm;
    }

    @Column(name = "resource_up_rate", precision = 5, scale = 2)
    public float getResourceUpRate() {
        return resourceUpRate;
    }

    public void setResourceUpRate(float resourceUpRate) {
        this.resourceUpRate = resourceUpRate;
    }

    @Column(name = "resource_dowm_rate", precision = 5, scale = 2)
    public float getResourceDowmRate() {
        return resourceDowmRate;
    }

    public void setResourceDowmRate(float resourceDowmRate) {
        this.resourceDowmRate = resourceDowmRate;
    }

    @Column(name = "caller")
    public String getCaller() {
        return caller;
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }
}
