package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import javax.persistence.*;
import java.util.Date;

@Entity
@Table(name = "gt_resource_alarm")
public class ResourceAlarm <T> extends BaseEntity {

    /**
     * 告警内容
     */
    private String message;
    /**
     * 告警类型
     */
    private String alarmType;
    /**
     * 告警时间
     */
    private Date alarmAt;
    /**
     * 告警通知人员
     */
    private String alarmTo;

    @Column(name = "message")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Column(name = "alarm_type",length=96)
    public String getAlarmType() {
        return alarmType;
    }

    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

    @Column(name = "alarm_at")
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat( pattern="yyyy-MM-dd HH:mm:ss")
    public Date getAlarmAt() {
        return alarmAt;
    }

    public void setAlarmAt(Date alarmAt) {
        this.alarmAt = alarmAt;
    }

    @Column(name = "alarm_to")
    public String getAlarmTo() {
        return alarmTo;
    }

    public void setAlarmTo(String alarmTo) {
        this.alarmTo = alarmTo;
    }
}
