package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;
import cn.gtmap.gtc.resource.domain.core.TimeCoverage;
import cn.gtmap.gtc.resource.domain.core.Title;
import cn.gtmap.gtc.resource.domain.core.Type;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * .Resource
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/11/4 14:12
 */
@Entity
@Table(name = "gt_resource", indexes = {
        @Index(columnList = "title", name = "res_title_idx"),
        @Index(columnList = "type", name = "res_type_idx"),
        @Index(columnList = "creator", name = "res_creator_idx"),
        @Index(columnList = "publisher", name = "res_publisher_idx"),
        @Index(columnList = "spatial_coverage_id", name = "res_sp_co_idx")
})
public class
Resource<T> extends BaseEntity implements Title, Type, TimeCoverage {

    /**
     * 标题
     */
    private String title;
    /**
     * 描述
     */
    private String description;
    /**
     * 关键字
     */
    private List<Keyword> keywords;
    /**
     * Collection
     * Dataset
     * Event
     * Image
     * InteractiveResource
     * MovingImage
     * Service
     * Software
     * Sound
     * Text
     */
    private String type;
    /**
     * 保存资源类型ID
     */
    @Column(name = "type_id",columnDefinition = "varchar(96)")
    private String typeId;
    /**
     * Media MINE Type·
     */
    private String format;
    /**
     * 创建者
     */
    private String creator;
    /**
     * 发布者
     */
    private String publisher;

    /**a
     * 时间范围，开始时间
     */
    private Date startAt;

    /**
     * 时间范围，结束时间
     */
    private Date endAt;

    /**
     * 空间覆盖范围
     */
    private SpatialCoverage spatialCoverage;

    /**
     * 关联资源，比如聚合拆分多资源关系体现
     */
    private List<Resource> relations;

    /**
     * 资源权限描述
     */
    private String rights;

    /**
     * 资源具体描述
     */
    private String source;

    /**
     * 归属资源目录
     */
    private List<Catalog> catalogs;

    /**
     * 资源能力
     *
     * @return
     */
    private List<Capable> capables;

    /**
     * 责任单位信息
     */
    private Responsible responsible;

    /**
     * 缩略图资源id
     */
    private String icon;

    /**
     * 行政区划
     */
    private String regionCode;

    /**
     * 资源权重
     */
    @Column(nullable = false, columnDefinition = "INT default 0")
    private Integer weight;

    /**
     * 注册资源(register)，下载资源(download)
     */
    @Column(nullable = true)
    private String status;

    //使用权限
    //公开(1)，有条件(2)，不公开(3)
    @Column(name = "permission")
    private String permission;
    //更新周期
    @Column(name = "resourceGxzq")
    private String resourceGxzq;


    //资源来源：例如本地还是省厅或者部里
    @Column(name="dataResource")
    private String dataResource;


    //年度字段
    private String ndStr;


    //图例字段
    @Column(name = "legend",columnDefinition = "varchar(255)")
    private String legend;

    /**
     * 资源是否审核发布
     */
    private Integer checked = 1;

    /*
    *  资源在线状态
    * */
    private Integer onlineStatus = 0;

    private ResourceStatus resourceStatus;

    /**
     * 是否公开
     */
    @Column(columnDefinition = "INT default 1")
    private int isPub = 1;

    /**
     * 关联资源申请
     */
    private List<ResourceApply> resourceApplyForeign;

    public String getResourceGxzq() {
        return resourceGxzq;
    }

    public void setResourceGxzq(String resourceGxzq) {
        this.resourceGxzq = resourceGxzq;
    }

    public String getPermission() {
        return permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }


    @Override
    public String getTitle() {
        return title;
    }

    public Resource setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public Resource setDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonIgnore
    @ManyToMany
    @JoinTable(name = "gt_res_kw_ref", joinColumns = @JoinColumn(name = "resource_id"), inverseJoinColumns = @JoinColumn(name = "keyword_id"))
    public List<Keyword> getKeywords() {
        return keywords;
    }

    public Resource setKeywords(List<Keyword> keywords) {
        this.keywords = keywords;
        return this;
    }

    @Override
    public String getType() {
        return type;
    }

    public Resource setType(String type) {
        this.type = type;
        return this;
    }

    public String getTypeId() {
        return typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    @Override
    public Date getEndAt() {
        return this.endAt;
    }

    public String getFormat() {
        return format;
    }

    public Resource setFormat(String format) {
        this.format = format;
        return this;
    }

    public String getCreator() {
        return creator;
    }

    public Resource setCreator(String creator) {
        this.creator = creator;
        return this;
    }

    public String getPublisher() {
        return publisher;
    }

    public Resource setPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    public Resource setEndAt(Date endAt) {
        this.endAt = endAt;
        return this;
    }

    @JsonIgnore
    @OneToOne(fetch = FetchType.EAGER, cascade = {CascadeType.ALL})
    public SpatialCoverage getSpatialCoverage() {
        return spatialCoverage;
    }

    public Resource setSpatialCoverage(SpatialCoverage spatialCoverage) {
        this.spatialCoverage = spatialCoverage;
        return this;
    }

    @JsonIgnore
    @ManyToMany
    @JoinTable(name = "gt_res_self_ref")
    public List<Resource> getRelations() {
        return relations;
    }

    public Resource setRelations(List<Resource> relations) {
        this.relations = relations;
        return this;
    }

    public String getRights() {
        return rights;
    }

    public Resource setRights(String rights) {
        this.rights = rights;
        return this;
    }

    @JsonIgnore
    @Basic(fetch = FetchType.LAZY)
//    @org.hibernate.annotations.Type(type = "json")
    @Lob
    /*@Column(columnDefinition = "json")  mysql 5.7 支持 */
    public String getSource() {
        return source;
    }

    public Resource setSource(T source) {
        if (source instanceof String) {
            this.source = String.valueOf(source);
        } else {
            try {
                this.source = JSON.toJSONString(source);
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                return this;
            }
        }
        return this;
    }

    @JsonIgnore
    @ManyToMany(mappedBy = "resources", cascade = {CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    public List<Catalog> getCatalogs() {
        return catalogs;
    }

    public Resource setCatalogs(List<Catalog> catalogs) {
        this.catalogs = catalogs;
        return this;
    }

    @Override
    public Date getStartAt() {
        return startAt;
    }

    public void setStartAt(Date startAt) {
        this.startAt = startAt;
    }

    @JsonIgnore
    @OneToMany(mappedBy = "resource",fetch = FetchType.LAZY)
    public List<Capable> getCapables() {
        return capables;
    }

    public Resource setCapables(List<Capable> capables) {
        this.capables = capables;
        return this;
    }

    @OneToOne(fetch = FetchType.EAGER, cascade = {CascadeType.ALL})
    public Responsible getResponsible() {
        return responsible;
    }

    public void setResponsible(Responsible responsible) {
        this.responsible = responsible;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Resource && getId().equals(((Resource) o).getId());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }


    public String getIcon() {
        return icon;
    }

    public Resource setIcon(String icon) {
        this.icon = icon;
        return this;
    }


    public String getRegionCode() {
        return regionCode;
    }

    public Resource setRegionCode(String regionCode) {
        this.regionCode = regionCode;
        return this;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }


    public String getDataResource() {
        return dataResource;
    }

    public void setDataResource(String dataResource) {
        this.dataResource = dataResource;
    }

    public Integer getChecked() {
        return checked;
    }

    public void setChecked(Integer checked) {
        this.checked = checked;
    }


    public String getNdStr() {
        return ndStr;
    }

    public void setNdStr(String ndStr) {
        this.ndStr = ndStr;
    }

    public String getLegend(){return legend;}

    public void setLegend(String legend){this.legend=legend;}

    @Column(name = "online_status")
    public Integer getOnlineStatus() {
        return onlineStatus;
    }

    public void setOnlineStatus(Integer onlineStatus) {
        this.onlineStatus = onlineStatus;
    }

    @JsonIgnore
    @OneToOne(fetch = FetchType.EAGER, cascade = {CascadeType.ALL})
    @org.hibernate.annotations.ForeignKey(name = "none")
    @NotFound(action= NotFoundAction.IGNORE)
    public ResourceStatus getResourceStatus() {
        return resourceStatus;
    }

    public void setResourceStatus(ResourceStatus resourceStatus) {
        this.resourceStatus = resourceStatus;
    }

    public int getIsPub() {
        return isPub;
    }
    public Resource<T> setIsPub(int isPub) {
        this.isPub = isPub;
        return this;
    }

    /**
     * 声明此id在别的表中是外键，对应字段名为mappedBy（没有“_id”的名字）
     * @return
     */
    @JsonIgnore
    @OneToMany(mappedBy = "foreignResource",fetch = FetchType.LAZY)
    public List<ResourceApply> getResourceApplyForeign() {
        return resourceApplyForeign;
    }

    public Resource setResourceApplyForeign(List<ResourceApply> resourceApplyForeign) {
        this.resourceApplyForeign = resourceApplyForeign;
        return this;
    }
}
