package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.List;

/**
 *  菜单树
 */
@Entity
@Table(name = "nodelist")
public class Nodelist {
    @Id
    @GeneratedValue(generator = "uuid")
    @GenericGenerator(name = "uuid", strategy = "uuid")
    private String uuid;//主键

    private String id;// 节点id
    private String nodename;//节点名称
    private String pid;// 父节点id
    private String type; //节点类型 资源：resource 目录：catalog
    private String expandStr; //扩展属性
    private String remark;
    @Column(nullable = false, columnDefinition = "INT default 0")
    private int weight;

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private boolean enabled = true;

    @Transient
    private List<Nodelist> children;

    public List<Nodelist> getChildren() {
        return children;
    }

    public Nodelist setChildren(List<Nodelist> children) {
        this.children = children;
        return this;
    }

    public String getNodename() {
        return nodename;
    }

    public Nodelist setNodename(String nodename) {
        this.nodename = nodename;
        return this;
    }

    public String getPid() {
        return pid;
    }

    public Nodelist setPid(String pid) {
        this.pid = pid;
        return this;
    }

    public String getId() {
        return id;
    }

    public Nodelist setId(String id) {
        this.id = id;
        return this;
    }

    public String getUuid() {
        return uuid;
    }

    public Nodelist setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public String getType() {
        return type;
    }

    public Nodelist setType(String type) {
        this.type = type;
        return this;
    }


    public String getExpandStr() {
        return expandStr;
    }

    public Nodelist setExpandStr(String expandStr) {
        this.expandStr = expandStr;
        return this;
    }


    public String getRemark() {
        return remark;
    }

    public Nodelist setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public int getWeight() {
        return weight;
    }

    public Nodelist setWeight(int weight) {
        this.weight = weight;
        return this;
    }

}
