package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;

import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 2 * @Author: zgl
 * 3 * @Date: 2020/10/22 14:41
 * 4  用于存储数据入库任务单以及数据汇交表相关数据
 */
@Entity
@Table(name = "gt_data_transfer")
public class DataTransfer extends BaseEntity {

    /**
     * 编号
     */
    private String serialNum;

    /**
     * 数据名称
     */
    private String title;

    /**
     * 数据应用要求
     */
    private String appRequire;

    /**
     * 数据内容描述
     */
    private String content;

    /**
     * 数据载体
     * 1、光盘   2、磁带  3、硬盘  4、其他
     */
    private String carrier;

    /**
     * 元数据说明
     */
    private String metadata;

    /**
     * 数据汇交部门、数据责任部门
     */
    private String transferDep;

    /**
     * 数据汇交经办人
     */
    private String transferMgr;

    /**
     * 数据接收经办人
     */
    private String acceptMgr;

    /**
     * 数据接收时间
     */
    private Date acceptDate;

    /**
     * 数据入库时间
     */
    private Date storageTime;

    /**
     * 旧-通过检查时间
     */
    private Date checkedDate;

    /**
     * 旧-出具凭证时间
     */
    private Date licenseDate;

    /**
     * 数据接收部门
     */
    private String acceptDep;

    private String taskId;


    /**
     * 工作流流程id
     */
    private String processInsId;

    private Date updateTime;

    private String format;

    private String coordinate;

    /**
     * 申请单位
     */
    private String departApply;

    /**
     * 申请日期
     */
    private String userApply;

    /**
     * 联系电话
     */
    private String phoneApply;

    /**
     * 附件上传文件
     */
    private String annexApplyUploadFile;

    // 202101新增
    /**
     * 数据检查人员
     */
    private String dataCheckPerson;

    /**
     * 数据检查时间-通过检查时间
     * @return
     */
    private String dataCheckTime;

    /**
     * 数据检查情况
     * @return
     */
    private String dataCheckContent;

    /**
     * 数据入库人员
     * @return
     */
    private String dataBasePerson;

    /**
     * 数据入库时间-出具凭证时间
     * @return
     */
    private String dataBaseTime;

    /**
     * 数据入库情况
     * @return
     */
    private String dataBaseContent;

    /**
     * 办理情况备注
     * @return
     */
    private String remark;

    /**
     * 数据检查意见
     * @return
     */
    private String dataSjjcOption;

    /**
     * 数据入库任务单——申请单位领导意见
     */
    private String sqdwOpinionStorage;

    /**
     * 数据入库任务单——信息中心领导办理意见
     */
    private String kjcOpinionStorage;

    /**
     * 数据入库任务单——信息中心领导意见
     */
    private String xxzxOpinionStorage;

    /**
     * 数据入库任务单——数据科办理意见
     */
    private String sjkOpinionStorage;

    /**
     * 数据入库任务单——数据经办人办理情况（办结）
     */
    private String sjjbrblOpinionStorage;

    public String getProcessInsId() {
        return processInsId;
    }

    public DataTransfer setProcessInsId(String processInsId) {
        this.processInsId = processInsId;
        return this;
    }


    public String getSerialNum() {
        return serialNum;
    }

    public DataTransfer setSerialNum(String serialNum) {
        this.serialNum = serialNum;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public DataTransfer setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getContent() {
        return content;
    }

    public DataTransfer setContent(String content) {
        this.content = content;
        return this;
    }

    public String getCarrier() {
        return carrier;
    }

    public DataTransfer setCarrier(String carrier) {
        this.carrier = carrier;
        return this;
    }

    public String getAcceptMgr() {
        return acceptMgr;
    }

    public DataTransfer setAcceptMgr(String acceptMgr) {
        this.acceptMgr = acceptMgr;
        return this;
    }

    public Date getAcceptDate() {
        return acceptDate;
    }

    public DataTransfer setAcceptDate(Date acceptDate) {
        this.acceptDate = acceptDate;
        return this;
    }

    public Date getStorageTime() {
        return storageTime;
    }

    public DataTransfer setStorageTime(Date storageTime) {
        this.storageTime = storageTime;
        return this;
    }

    public Date getCheckedDate() {
        return checkedDate;
    }

    public DataTransfer setCheckedDate(Date checkedDate) {
        this.checkedDate = checkedDate;
        return this;
    }

    public Date getLicenseDate() {
        return licenseDate;
    }

    public DataTransfer setLicenseDate(Date licenseDate) {
        this.licenseDate = licenseDate;
        return this;
    }

    public String getAcceptDep() {
        return acceptDep;
    }

    public DataTransfer setAcceptDep(String acceptDep) {
        this.acceptDep = acceptDep;
        return this;
    }

    public String getTransferDep() {
        return transferDep;
    }

    public DataTransfer setTransferDep(String transferDep) {
        this.transferDep = transferDep;
        return this;
    }

    public String getTaskId() {
        return taskId;
    }

    public DataTransfer setTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public DataTransfer setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public String getFormat() {
        return format;
    }

    public DataTransfer setFormat(String format) {
        this.format = format;
        return this;
    }

    public String getCoordinate() {
        return coordinate;
    }

    public DataTransfer setCoordinate(String coordinate) {
        this.coordinate = coordinate;
        return this;
    }

    public String getDataCheckPerson() {
        return dataCheckPerson;
    }

    public DataTransfer setDataCheckPerson(String dataCheckPerson) {
        this.dataCheckPerson = dataCheckPerson;
        return this;
    }

    public String getDataCheckTime() {
        return dataCheckTime;
    }

    public DataTransfer setDataCheckTime(String dataCheckTime) {
        this.dataCheckTime = dataCheckTime;
        return this;
    }

    public String getdataBasePerson() {
        return dataBasePerson;
    }

    public DataTransfer setDataBasePerson(String dataBasePerson) {
        this.dataBasePerson = dataBasePerson;
        return this;
    }

    public String getDataBaseTime() {
        return dataBaseTime;
    }

    public DataTransfer setDataBaseTime(String dataBaseTime) {
        this.dataBaseTime = dataBaseTime;
        return this;
    }

    public String getDataSjjcOption() {
        return dataSjjcOption;
    }

    public DataTransfer setDataSjjcOption(String dataSjjcOption) {
        this.dataSjjcOption = dataSjjcOption;
        return this;
    }

    public String getXxzxOpinionStorage() {
        return xxzxOpinionStorage;
    }

    public DataTransfer setXxzxOpinionStorage(String xxzxOpinionStorage) {
        this.xxzxOpinionStorage = xxzxOpinionStorage;
        return this;
    }

    public String getSjkOpinionStorage() {
        return sjkOpinionStorage;
    }

    public DataTransfer setSjkOpinionStorage(String sjkOpinionStorage) {
        this.sjkOpinionStorage = sjkOpinionStorage;
        return this;
    }

    public String getAppRequire() {
        return appRequire;
    }

    public DataTransfer setAppRequire(String appRequire) {
        this.appRequire = appRequire;
        return this;
    }

    public String getMetadata() {
        return metadata;
    }

    public DataTransfer setMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getTransferMgr() {
        return transferMgr;
    }

    public DataTransfer setTransferMgr(String transferMgr) {
        this.transferMgr = transferMgr;
        return this;
    }

    public String getDepartApply() {
        return departApply;
    }

    public DataTransfer setDepartApply(String departApply) {
        this.departApply = departApply;
        return this;
    }

    public String getUserApply() {
        return userApply;
    }

    public DataTransfer setUserApply(String userApply) {
        this.userApply = userApply;
        return this;
    }

    public String getPhoneApply() {
        return phoneApply;
    }

    public DataTransfer setPhoneApply(String phoneApply) {
        this.phoneApply = phoneApply;
        return this;
    }

    public String getAnnexApplyUploadFile() {
        return annexApplyUploadFile;
    }

    public DataTransfer setAnnexApplyUploadFile(String annexApplyUploadFile) {
        this.annexApplyUploadFile = annexApplyUploadFile;
        return this;
    }

    public String getDataCheckContent() {
        return dataCheckContent;
    }

    public DataTransfer setDataCheckContent(String dataCheckContent) {
        this.dataCheckContent = dataCheckContent;
        return this;
    }

    public String getDataBaseContent() {
        return dataBaseContent;
    }

    public DataTransfer setDataBaseContent(String dataBaseContent) {
        this.dataBaseContent = dataBaseContent;
        return this;
    }

    public String getRemark() {
        return remark;
    }

    public DataTransfer setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public String getSqdwOpinionStorage() {
        return sqdwOpinionStorage;
    }

    public DataTransfer setSqdwOpinionStorage(String sqdwOpinionStorage) {
        this.sqdwOpinionStorage = sqdwOpinionStorage;
        return this;
    }

    public String getKjcOpinionStorage() {
        return kjcOpinionStorage;
    }

    public DataTransfer setKjcOpinionStorage(String kjcOpinionStorage) {
        this.kjcOpinionStorage = kjcOpinionStorage;
        return this;
    }

    public String getSjjbrblOpinionStorage() {
        return sjjbrblOpinionStorage;
    }

    public DataTransfer setSjjbrblOpinionStorage(String sjjbrblOpinionStorage) {
        this.sjjbrblOpinionStorage = sjjbrblOpinionStorage;
        return this;
    }
}
