package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;

import javax.persistence.*;
import java.util.Date;

/**
 * 2 * @Author: zgl
 * 3 * @Date: 2020/10/24 10:57
 * 4 * 用于存储数据（服务）提供申请单相关数据
 */
@Entity
@Table(name = "gt_data_apply")
public class DataApply extends BaseEntity {
    /**
     * 编号
     */
    private String serialNum;
    /**
     * 任务名称
     */
    private String rwmc;
    /**
     * 办理期限
     */
    private String blqx;
    /**
     * 数据类型名称
     */
    @Column(name = "sjlx_name")
    private String sjlxName;
    /**
     * 加工类别
     */
    private String jdlb;
    /**
     * 完成要求
     */
    private String wcyq;
    /**
     * 编号简称: 宁
     */
    private String serialJc;
    /**
     * 编号时间；2019
     */
    private String serialNd;
    /**
     * 编号序号：2
     */
    private String serialNo;
    /**
     * 是否保密
     */
    private boolean isSec;
    /**
     * 使用许可编号
     */
    private String syxkbh;
    /**
     * 保管方
     */
    private String bgf;
    /**
     * 使用方
     */
    private String syf;
    /**
     * 数据名称
     */
    private String sjmc;
    /**
     * 数据格式
     */
    private String sjgs;
    /**
     * 数据内容
     */
    private String sjnr;

    /**
     * 许可使用的涉密数据
     */
    private String xksydsmsj;
    /**
     * 密级
     */
    private String mj;
    /**
     * 地理范围
     */
    private String dlfw;
    /**
     * 特别许可
     */
    private String tbxk;
    /**
     * 数据载体
     */
    private String sjzt;
    /**
     * 其他事项
     */
    private String qtsx;
    /**
     * 许可使用的涉密数据
     */
    private String xkdsyyt;
    /**
     * 提交数据的时间
     */
    private String tjsjsj;
    /**
     * 提交数据的地点
     */
    private String tjsjdd;
    /**
     * 费用
     */
    private String fy;
    /**
     * 全额(人民币)
     */
    private String qe;
    /**
     * 使用付款方式
     */
    private String syfkfs;
    /**
     * 付款时间
     */
    private String fksj;
    /**
     * 保密备注
     */
    private String bmbz;
    /**
     * 申请部门
     */
    private String sqbm;
    /**
     * 申请日期
     */
    private String sqrq;
    /**
     * 申请业务和数据详细情况
     */
    private String sqywsjqk;
    /**
     * 申请原因和用途
     */
    private String sqyyhyt;
    /**
     * 申请经办人
     */
    private String sqjbr;
    /**
     * 申请负责人
     */
    private String sqfzr;
    /**
     * 会商部门
     */
    private String hsbm;
    /**
     * 会商负责人
     */
    private String hsfzr;
    /**
     * 扎口部门
     */
    private String zkbm;
    /**
     * 扎口经办人
     */
    private String zkjbr;
    /**
     * 扎口负责人
     */
    private String zkfzr;
    /**
     * 办理部门中心领导
     */
    private String blbmzxld;
    /**
     * 办理部门总工办
     */
    private String blbmzgb;

    /**
     * 办理部门
     */
    private String blbm;
    /**
     * 办理情况
     */
    private String blqk;
    /**
     * 办理备注
     */
    private String blbz;

    /**
     * 任务id
     */
    @Column(name = "task_id", columnDefinition = "varchar(32)")
    private String taskId;

    /**
     * 工作流流程id
     */
    @Column(name = "process_ins_id", length = 32)
    private String processInsId;

    /**
     * 下载资源id
     */
    @Column(name = "storage_id", length = 55)
    private String storageId;

    /**
     * 下载申请任务id
     */
    @Column(name = "data_download_task_id", length = 55)
    private String dataDownloadTaskId;

    /**
     * 数据接收人
     */
    @Column(name = "data_accept_person", length = 55)
    private String dataAcceptPerson;

    /**
     * 服务申请访问相关传参
     * <p>
     * 资源类型（serviceType）
     * 申请资源id（serviceArr）
     * 通过申请的能力（serviceApprovalArr）
     * 申请资源标题（serviceTitleArr）
     * 申请资源的任务id（serviceApplyTaskId）
     */
    @Column(name = "service_apply_data")
    private String serviceApplyData;

    // 2021-01-27更新，签名不走流程，直接走表单数据

    /**
     * 数据（服务）提供申请单——市局网信办意见
     *
     * @return
     */
    private String wxbOpinionApply;

    /////////////////////////////////////////////////数据共享申请表单参数-begin/////////////////////////////////////////////////
    /**
     * 申请单位
     */
    @Column(name = "sydw", length = 132)
    private String sydw;

    /**
     * 申请日期
     */
    private Date xdsj;

    /**
     * 申请联系人
     */
    @Column(name = "sqlxr", length = 32)
    private String sqlxr;

    /**
     * 申请联系电话
     */
    @Column(name = "sqlxdh", length = 32)
    private String sqlxdh;

    /**
     * 具体内容
     */
    @Column(name = "content")
    private String content;

    /**
     * 使用目的
     */
    @Column(name = "objective")
    private String objective;

    /**
     * 数据类型
     */
    @Column(name = "sjlx", length = 155)
    private String sjlx;

    /**
     * 数据范围类型(用于数据下载*申请*时指定范围方式)
     */
    @Column(name = "sjfwlx")
    private String sjfwlx;

    /**
     * 数据申请人-申请行政区范围
     */
    @Column(name = "xzqdm")
    private String xzqdm;

    /**
     * 数据申请人-自定义shp范围-JSON.stringify("/nrc/rest/resource/query/getShapeFileSpatial"上传成功的结果)
     * userDefineUpLoadShpApply
     */
    @Column(name = "user_define_shp_apply")
    private String userDefineShpApply;

    /**
     * 数据申请人-自定义shp范围-转换后的shp
     * userDefineUpLoadShpApplyTrans
     */
    @Column(name = "user_define_shp_apply_trans")
    private String userDefineShpApplyTrans;

    /**
     * 申请函附件
     */
    @Column(name = "application_letter", length = 55)
    private String applicationLetter;

    /**
     * 保密协议附件
     */
    @Column(name = "confidentiality_agreement", length = 55)
    private String confidentialityAgreement;

    /**
     * 共享合作协议
     */
    @Column(name = "sharing_agreement", length = 55)
    private String sharingAgreement;

    /**
     * 数据提供方式(共享方式)
     */
    @Column(name = "data_supply_way", length = 55)
    private String dataSupplyWay;

    /**
     * 数据提供人
     */
    @Column(name = "data_supply_person", length = 55)
    private String dataSupplyPerson;

    /**
     * 数据提供时间
     */
    private Date dataSupplyDate;

    /**
     * 存储提供业务图层的属性字段
     */
    @Column(name = "attribute_fields")
    private String attributeFields;

    /**
     * 数据*提供*范围类型
     */
    @Column(name = "data_supply_area_type")
    private String dataSupplyAreaType;

    /**
     * 数据提供范围类型-按行政区划范围
     */
    @Column(name = "data_supply_region")
    private String dataSupplyRegion;

    /**
     * 数据提供范围类型-提供人自定义shp范围
     * userDefineUpLoadShpSupply
     */
    @Column(name = "user_define_shp_supply")
    private String userDefineShpSupply;

    /**
     * 数据提供范围类型-提供人自定义shp范围-转换后的shp范围
     * userDefineUpLoadShpSupplyTrans
     */
    @Column(name = "user_define_shp_supply_trans")
    private String userDefineShpSupplyTrans;

    /**
     * 离线下载提供数据范围文件 dataSupplyOffLineUploadFile
     */
    @Column(name = "ds_offline_upload_file")
    private String dsOfflineUploadFile;

    /**
     * 线下提供数据交接单文件 dataSupplyOffLineFaceToFaceUploadFile
     */
    @Column(name = "ds_offline_ftf_file", length = 55)
    private String dsOfflineFtfFile;

    /**
     * 数据（服务）提供申请单——申请单位领导审批意见
     */
    @Column(name = "sqdwldsp_opinion_apply")
    private String sqdwldspOpinionApply;

    /**
     * 数据（服务）提供申请单——数据责任处室意见
     *
     * @return
     */
    @Column(name = "sjzrcs_opinion_apply")
    private String sjzrcsOpinionApply;

    /**
     * 数据（服务）提供申请单——信息中心意见
     */
    @Column(name = "xxzx_opinion_apply")
    private String xxzxOpinionApply;

    /**
     * 数据科领导意见
     */
    @Column(name = "sjk_opinion_apply")
    private String sjkOpinionApply;

    /**
     * 数据经办人办理情况
     */
    @Column(name = "sjjbr_opinion_apply")
    private String sjjbrOpinionApply;

    /**
     * 数据接收办结
     */
    @Column(name = "sjjs_opinion_apply")
    private String sjjsOpinionApply;

    /**
     * 责任处室意见汇签
     */
    @Column(name = "zrcs_multi_opinion_apply")
    private String zrcsMultiOpinionApply;

    /**
     * 其他附加参数
     */
    @Column(name = "others")
    private String others;
    /////////////////////////////////////////////////数据共享申请表单签名-end/////////////////////////////////////////////////

    public String getProcessInsId() {
        return processInsId;
    }

    public DataApply setProcessInsId(String processInsId) {
        this.processInsId = processInsId;
        return this;
    }

    public String getSerialNum() {
        return serialNum;
    }

    public DataApply setSerialNum(String serialNum) {
        this.serialNum = serialNum;
        return this;
    }

    public String getRwmc() {
        return rwmc;
    }

    public DataApply setRwmc(String rwmc) {
        this.rwmc = rwmc;
        return this;
    }

    public String getSydw() {
        return sydw;
    }

    public DataApply setSydw(String sydw) {
        this.sydw = sydw;
        return this;
    }

    public Date getXdsj() {
        return xdsj;
    }

    public DataApply setXdsj(Date xdsj) {
        this.xdsj = xdsj;
        return this;
    }

    public String getBlqx() {
        return blqx;
    }

    public DataApply setBlqx(String blqx) {
        this.blqx = blqx;
        return this;
    }

    public String getSjlx() {
        return sjlx;
    }

    public DataApply setSjlx(String sjlx) {
        this.sjlx = sjlx;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getXzqdm() {
        return xzqdm;
    }

    public DataApply setXzqdm(String xzqdm) {
        this.xzqdm = xzqdm;
        return this;
    }

    public String getJdlb() {
        return jdlb;
    }

    public DataApply setJdlb(String jdlb) {
        this.jdlb = jdlb;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getContent() {
        return content;
    }

    public DataApply setContent(String content) {
        this.content = content;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getObjective() {
        return objective;
    }

    public DataApply setObjective(String objective) {
        this.objective = objective;
        return this;
    }

    public String getWcyq() {
        return wcyq;
    }

    public DataApply setWcyq(String wcyq) {
        this.wcyq = wcyq;
        return this;
    }

    public String getSerialJc() {
        return serialJc;
    }

    public DataApply setSerialJc(String serialJc) {
        this.serialJc = serialJc;
        return this;
    }

    public String getSerialNd() {
        return serialNd;
    }

    public DataApply setSerialNd(String serialNd) {
        this.serialNd = serialNd;
        return this;
    }

    public String getSerialNo() {
        return serialNo;
    }

    public DataApply setSerialNo(String serialNo) {
        this.serialNo = serialNo;
        return this;
    }

    public boolean isSec() {
        return isSec;
    }

    public DataApply setSec(boolean sec) {
        isSec = sec;
        return this;
    }

    public String getSyxkbh() {
        return syxkbh;
    }

    public DataApply setSyxkbh(String syxkbh) {
        this.syxkbh = syxkbh;
        return this;
    }

    public String getBgf() {
        return bgf;
    }

    public DataApply setBgf(String bgf) {
        this.bgf = bgf;
        return this;
    }

    public String getSyf() {
        return syf;
    }

    public DataApply setSyf(String syf) {
        this.syf = syf;
        return this;
    }

    public String getSjmc() {
        return sjmc;
    }

    public DataApply setSjmc(String sjmc) {
        this.sjmc = sjmc;
        return this;
    }

    public String getSjgs() {
        return sjgs;
    }

    public DataApply setSjgs(String sjgs) {
        this.sjgs = sjgs;
        return this;
    }

    public String getSjnr() {
        return sjnr;
    }

    public DataApply setSjnr(String sjnr) {
        this.sjnr = sjnr;
        return this;
    }

    public String getXksydsmsj() {
        return xksydsmsj;
    }

    public DataApply setXksydsmsj(String xksydsmsj) {
        this.xksydsmsj = xksydsmsj;
        return this;
    }

    public String getMj() {
        return mj;
    }

    public DataApply setMj(String mj) {
        this.mj = mj;
        return this;
    }

    public String getDlfw() {
        return dlfw;
    }

    public DataApply setDlfw(String dlfw) {
        this.dlfw = dlfw;
        return this;
    }

    public String getTbxk() {
        return tbxk;
    }

    public DataApply setTbxk(String tbxk) {
        this.tbxk = tbxk;
        return this;
    }

    public String getSjzt() {
        return sjzt;
    }

    public DataApply setSjzt(String sjzt) {
        this.sjzt = sjzt;
        return this;
    }

    public String getQtsx() {
        return qtsx;
    }

    public DataApply setQtsx(String qtsx) {
        this.qtsx = qtsx;
        return this;
    }

    public String getXkdsyyt() {
        return xkdsyyt;
    }

    public DataApply setXkdsyyt(String xkdsyyt) {
        this.xkdsyyt = xkdsyyt;
        return this;
    }

    public String getTjsjsj() {
        return tjsjsj;
    }

    public DataApply setTjsjsj(String tjsjsj) {
        this.tjsjsj = tjsjsj;
        return this;
    }

    public String getTjsjdd() {
        return tjsjdd;
    }

    public DataApply setTjsjdd(String tjsjdd) {
        this.tjsjdd = tjsjdd;
        return this;
    }

    public String getFy() {
        return fy;
    }

    public DataApply setFy(String fy) {
        this.fy = fy;
        return this;
    }

    public String getQe() {
        return qe;
    }

    public DataApply setQe(String qe) {
        this.qe = qe;
        return this;
    }

    public String getSyfkfs() {
        return syfkfs;
    }

    public DataApply setSyfkfs(String syfkfs) {
        this.syfkfs = syfkfs;
        return this;
    }

    public String getFksj() {
        return fksj;
    }

    public DataApply setFksj(String fksj) {
        this.fksj = fksj;
        return this;
    }

    public String getBmbz() {
        return bmbz;
    }

    public DataApply setBmbz(String bmbz) {
        this.bmbz = bmbz;
        return this;
    }

    public String getSqbm() {
        return sqbm;
    }

    public DataApply setSqbm(String sqbm) {
        this.sqbm = sqbm;
        return this;
    }

    public String getSqrq() {
        return sqrq;
    }

    public DataApply setSqrq(String sqrq) {
        this.sqrq = sqrq;
        return this;
    }

    public String getSqlxr() {
        return sqlxr;
    }

    public DataApply setSqlxr(String sqlxr) {
        this.sqlxr = sqlxr;
        return this;
    }

    public String getSqlxdh() {
        return sqlxdh;
    }

    public DataApply setSqlxdh(String sqlxdh) {
        this.sqlxdh = sqlxdh;
        return this;
    }

    public String getSqywsjqk() {
        return sqywsjqk;
    }

    public DataApply setSqywsjqk(String sqywsjqk) {
        this.sqywsjqk = sqywsjqk;
        return this;
    }

    public String getSqyyhyt() {
        return sqyyhyt;
    }

    public DataApply setSqyyhyt(String sqyyhyt) {
        this.sqyyhyt = sqyyhyt;
        return this;
    }

    public String getSqjbr() {
        return sqjbr;
    }

    public DataApply setSqjbr(String sqjbr) {
        this.sqjbr = sqjbr;
        return this;
    }

    public String getSqfzr() {
        return sqfzr;
    }

    public DataApply setSqfzr(String sqfzr) {
        this.sqfzr = sqfzr;
        return this;
    }

    public String getHsbm() {
        return hsbm;
    }

    public DataApply setHsbm(String hsbm) {
        this.hsbm = hsbm;
        return this;
    }

    public String getHsfzr() {
        return hsfzr;
    }

    public DataApply setHsfzr(String hsfzr) {
        this.hsfzr = hsfzr;
        return this;
    }

    public String getZkbm() {
        return zkbm;
    }

    public DataApply setZkbm(String zkbm) {
        this.zkbm = zkbm;
        return this;
    }

    public String getZkjbr() {
        return zkjbr;
    }

    public DataApply setZkjbr(String zkjbr) {
        this.zkjbr = zkjbr;
        return this;
    }

    public String getZkfzr() {
        return zkfzr;
    }

    public DataApply setZkfzr(String zkfzr) {
        this.zkfzr = zkfzr;
        return this;
    }

    public String getBlbmzxld() {
        return blbmzxld;
    }

    public DataApply setBlbmzxld(String blbmzxld) {
        this.blbmzxld = blbmzxld;
        return this;
    }

    public String getBlbmzgb() {
        return blbmzgb;
    }

    public DataApply setBlbmzgb(String blbmzgb) {
        this.blbmzgb = blbmzgb;
        return this;
    }

    public String getBlqk() {
        return blqk;
    }

    public DataApply setBlqk(String blqk) {
        this.blqk = blqk;
        return this;
    }

    public String getBlbz() {
        return blbz;
    }

    public DataApply setBlbz(String blbz) {
        this.blbz = blbz;
        return this;
    }

    public String getBlbm() {
        return blbm;
    }

    public DataApply setBlbm(String blbm) {
        this.blbm = blbm;
        return this;
    }

    public String getTaskId() {
        return taskId;
    }

    public DataApply setTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public String getStorageId() {
        return storageId;
    }

    public DataApply setStorageId(String storageId) {
        this.storageId = storageId;
        return this;
    }

    public String getDataDownloadTaskId() {
        return dataDownloadTaskId;
    }

    public void setDataDownloadTaskId(String dataDownloadTaskId) {
        this.dataDownloadTaskId = dataDownloadTaskId;
    }

    public String getDataAcceptPerson() {
        return dataAcceptPerson;
    }

    public DataApply setDataAcceptPerson(String dataAcceptPerson) {
        this.dataAcceptPerson = dataAcceptPerson;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getServiceApplyData() {
        return serviceApplyData;
    }

    public DataApply setServiceApplyData(String serviceApplyData) {
        this.serviceApplyData = serviceApplyData;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getSqdwldspOpinionApply() {
        return sqdwldspOpinionApply;
    }

    public DataApply setSqdwldspOpinionApply(String sqdwldspOpinionApply) {
        this.sqdwldspOpinionApply = sqdwldspOpinionApply;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getSjzrcsOpinionApply() {
        return sjzrcsOpinionApply;
    }

    public DataApply setSjzrcsOpinionApply(String sjzrcsOpinionApply) {
        this.sjzrcsOpinionApply = sjzrcsOpinionApply;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getXxzxOpinionApply() {
        return xxzxOpinionApply;
    }

    public DataApply setXxzxOpinionApply(String xxzxOpinionApply) {
        this.xxzxOpinionApply = xxzxOpinionApply;
        return this;
    }

    public String getWxbOpinionApply() {
        return wxbOpinionApply;
    }

    public DataApply setWxbOpinionApply(String wxbOpinionApply) {
        this.wxbOpinionApply = wxbOpinionApply;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getSjfwlx() {
        return sjfwlx;
    }

    public DataApply setSjfwlx(String sjfwlx) {
        this.sjfwlx = sjfwlx;
        return this;
    }

    public String getDataSupplyPerson() {
        return dataSupplyPerson;
    }

    public DataApply setDataSupplyPerson(String dataSupplyPerson) {
        this.dataSupplyPerson = dataSupplyPerson;
        return this;
    }

    public Date getDataSupplyDate() {
        return dataSupplyDate;
    }

    public DataApply setDataSupplyDate(Date dataSupplyDate) {
        this.dataSupplyDate = dataSupplyDate;
        return this;
    }

    public String getApplicationLetter() {
        return applicationLetter;
    }

    public DataApply setApplicationLetter(String applicationLetter) {
        this.applicationLetter = applicationLetter;
        return this;
    }

    public String getConfidentialityAgreement() {
        return confidentialityAgreement;
    }

    public DataApply setConfidentialityAgreement(String confidentialityAgreement) {
        this.confidentialityAgreement = confidentialityAgreement;
        return this;
    }

    public String getSharingAgreement() {
        return sharingAgreement;
    }

    public DataApply setSharingAgreement(String sharingAgreement) {
        this.sharingAgreement = sharingAgreement;
        return this;
    }

    public String getDataSupplyWay() {
        return dataSupplyWay;
    }

    public DataApply setDataSupplyWay(String dataSupplyWay) {
        this.dataSupplyWay = dataSupplyWay;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getDataSupplyAreaType() {
        return dataSupplyAreaType;
    }

    public DataApply setDataSupplyAreaType(String dataSupplyAreaType) {
        this.dataSupplyAreaType = dataSupplyAreaType;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getDataSupplyRegion() {
        return dataSupplyRegion;
    }

    public DataApply setDataSupplyRegion(String dataSupplyRegion) {
        this.dataSupplyRegion = dataSupplyRegion;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getDsOfflineUploadFile() {
        return dsOfflineUploadFile;
    }

    public DataApply setDsOfflineUploadFile(String dsOfflineUploadFile) {
        this.dsOfflineUploadFile = dsOfflineUploadFile;
        return this;
    }

    public String getDsOfflineFtfFile() {
        return dsOfflineFtfFile;
    }

    public DataApply setDsOfflineFtfFile(String dsOfflineFtfFile) {
        this.dsOfflineFtfFile = dsOfflineFtfFile;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getSjkOpinionApply() {
        return sjkOpinionApply;
    }

    public DataApply setSjkOpinionApply(String sjkOpinionApply) {
        this.sjkOpinionApply = sjkOpinionApply;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getSjjbrOpinionApply() {
        return sjjbrOpinionApply;
    }

    public DataApply setSjjbrOpinionApply(String sjjbrOpinionApply) {
        this.sjjbrOpinionApply = sjjbrOpinionApply;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getSjjsOpinionApply() {
        return sjjsOpinionApply;
    }

    public DataApply setSjjsOpinionApply(String sjjsOpinionApply) {
        this.sjjsOpinionApply = sjjsOpinionApply;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getAttributeFields() {
        return attributeFields;
    }

    public DataApply setAttributeFields(String attributeFields) {
        this.attributeFields = attributeFields;
        return this;
    }

    public String getUserDefineShpApply() {
        return userDefineShpApply;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public DataApply setUserDefineShpApply(String userDefineShpApply) {
        this.userDefineShpApply = userDefineShpApply;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getUserDefineShpSupply() {
        return userDefineShpSupply;
    }

    public DataApply setUserDefineShpSupply(String userDefineShpSupply) {
        this.userDefineShpSupply = userDefineShpSupply;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getUserDefineShpApplyTrans() {
        return userDefineShpApplyTrans;
    }

    public DataApply setUserDefineShpApplyTrans(String userDefineShpApplyTrans) {
        this.userDefineShpApplyTrans = userDefineShpApplyTrans;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getUserDefineShpSupplyTrans() {
        return userDefineShpSupplyTrans;
    }

    public DataApply setUserDefineShpSupplyTrans(String userDefineShpSupplyTrans) {
        this.userDefineShpSupplyTrans = userDefineShpSupplyTrans;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getSjlxName() {
        return sjlxName;
    }

    public DataApply setSjlxName(String sjlxName) {
        this.sjlxName = sjlxName;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getZrcsMultiOpinionApply() {
        return zrcsMultiOpinionApply;
    }

    public DataApply setZrcsMultiOpinionApply(String zrcsMultiOpinionApply) {
        this.zrcsMultiOpinionApply = zrcsMultiOpinionApply;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    @Column(columnDefinition = "text")
    public String getOthers() {
        return others;
    }

    public DataApply setOthers(String others) {
        this.others = others;
        return this;
    }
}
