package cn.gtmap.gtc.resource.domain.resource.metadata;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * Created by xpy on 2021-01-24.
 */
@Data
@Entity
@Table(name = "gt_cat_res_type_ref")
public class CatalogResTypeRef {

    @Id
    @GeneratedValue(generator = "uuid")
    @GenericGenerator(name = "uuid", strategy = "uuid")
    @Column(unique = true, nullable = false, updatable = false, length = 32)
    private String id;

    /**
     * 资源类型id
     */
    @Column(name = "resource_type_id",columnDefinition = "varchar(96)")
    private String resourceTypeId;
    /**
     * 资源类型属性id
     */
    @Column(name = "resource_type_attribute_id",columnDefinition = "varchar(96)")
    private String resourceTypeAttributeId;
    /**
     * 资源类型属性字典项id
     */
    @Column(name = "resource_attribute_dict_id",columnDefinition = "varchar(96)")
    private String resourceAttributeDictId;

    @Column(name = "weight",columnDefinition = "int default 0")
    private int weight;

}
