package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;
import cn.gtmap.gtc.resource.domain.core.Order;
import cn.gtmap.gtc.resource.domain.core.Status;
import cn.gtmap.gtc.resource.domain.core.Title;
import cn.gtmap.gtc.resource.domain.core.Url;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.persistence.*;
import java.util.Objects;

/**
 * .Capablity
 * <p>
 * 资源支持的能力接口
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/11/8 15:43
 */
@Entity
@Table(name = "gt_res_capable", indexes = {
        @Index(columnList = "title", name = "capcable_title_idx"),
        @Index(columnList = "type", name = "capable_type_idx")
})
public class Capable<T> extends BaseEntity implements Title, Url, Order, Status {

    /**
     * 能力描述
     */
    private String title;
    /**
     * 能力类型
     */
    private CapableType type;
    /**
     * 权重
     */
    private int weight;
    /**
     * 状态
     */
    private String status;
    /**
     * 能力相关配置信息
     */
    private String info;
    /**
     * 能力访问地址
     */
    private String url;

    private Resource resource;

    /**
     * 判断数据下载的状态码
     * 100:正在运行;
     * 200:执行正常;
     * 300:没有数据;
     * 500:发生错误;
     */
    @Column(name = "code")
    private String code;
    //图层更新周期
    @Column(name = "layerGxzq")
    private String layerGxzq;

    /**
     * 反向代理地址
     */
    private String proxyUrl;

    /**
     * 服务版本
     */
    private String version;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getTitle() {
        return title;
    }

    public Capable setTitle(String title) {
        this.title = title;
        return this;
    }

    @Enumerated(EnumType.STRING)
    public CapableType getType() {
        return type;
    }

    public Capable setType(CapableType type) {
        this.type = type;
        return this;
    }

    @Override
    public int getWeight() {
        return weight;
    }

    public Capable setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    @Override
    public String getStatus() {
        return status;
    }

    public Capable setStatus(String status) {
        this.status = status;
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
//    @org.hibernate.annotations.Type(type = "json")
    @Lob
    public String getInfo() {
        return info;
    }

    @JsonProperty
    public Capable setInfo(T info) {
        if (info instanceof String) {
            this.info = String.valueOf(info);
        } else {
            try {
                this.info = JSON.toJSONString(info);
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                return this;
            }
        }
        return this;
    }

    @Override
    public String getUrl() {
        return url;
    }

    public Capable setUrl(String url) {
        this.url = url;
        return this;
    }

    @ManyToOne()
    @JoinColumn(name = "resource_id")
    public Resource getResource() {
        return resource;
    }

    public Capable setResource(Resource resource) {
        this.resource = resource;
        return this;
    }


    @Override
    public boolean equals(Object obj) {
        String id = "";
        if (obj == null) {
            return false;
        } else {
            if (this.getClass() != obj.getClass()) {
                return false;
            } else {
                id = ((Capable) obj).getId();
                return this.getId().equals(id);
            }
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getId());
    }
}
