package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

/**
 * 1 * @Author: zgl
 * 2 * @Date: 2020/6/9 15:38
 * 3
 */
@Entity
@Table(name = "gt_apply_ref")
public class ApplyRef {

    private String id;

    @Id
    @GeneratedValue(generator = "uuid")
    @GenericGenerator(name = "uuid", strategy = "uuid")
    @Column(unique = true, nullable = false, updatable = false, length = 32)
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    /**
     * 资源申请id
     */
    @Column(columnDefinition = "varchar(1000)")

    private String applyIds;
    /**
     * 资源申请状态
     */
    private String appState;

    /**
     * 申请人
     */
    private String applicant;

    /**
     * 审批人
     */
    private String auditor;

    /**
     * 资源：resource、 数据汇交：dataTransfer、 数据申请：dataApply、数据维护：dataRepair
     */
    private String type;

    /**
     * 工作流流程id
     */
    private String processInsId;

    public String getProcessInsId() {
        return processInsId;
    }

    public ApplyRef setProcessInsId(String processInsId) {
        this.processInsId = processInsId;
        return this;
    }

    public String getType() {
        return type;
    }

    public ApplyRef setType(String type) {
        this.type = type;
        return this;
    }

    //创建时间
    private Date createAt;

    //修改时间
    private Date updateAt;

    protected boolean enabled = true;

    public String getApplyIds() {
        return applyIds;
    }

    public ApplyRef setApplyIds(String applyIds) {
        this.applyIds = applyIds;
        return this;
    }

    public String getAppState() {
        return appState;
    }

    public ApplyRef setAppState(String appState) {
        this.appState = appState;
        return this;
    }

    public String getApplicant() {
        return applicant;
    }

    public ApplyRef setApplicant(String applicant) {
        this.applicant = applicant;
        return this;
    }

    public String getAuditor() {
        return auditor;
    }

    public ApplyRef setAuditor(String auditor) {
        this.auditor = auditor;
        return this;
    }


    public Date getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Date createAt) {
        this.createAt = createAt;
    }

    public Date getUpdateAt() {
        return updateAt;
    }

    public void setUpdateAt(Date updateAt) {
        this.updateAt = updateAt;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}
