package cn.gtmap.gtc.resource.domain.resource.dto.tpl.map;

import cn.gtmap.gtc.resource.domain.core.Title;
import cn.gtmap.gtc.resource.domain.resource.dto.resource.ResourceLayer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * .Configuration
 *
 * @author <a href="mailto:yingxiufeng@gtmap.cn">alex.y</a>
 * @version v1.0, 2018/3/28 (c) Copyright gtmap Corp.
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class Configuration implements Title, Serializable {

    public Configuration() {
        tools = new ArrayList<>();
        widgets = new ArrayList<>();
        controls = new ArrayList<>();
    }

    /**
     * 标题
     */
    private String title;

    /**
     * logo 路径
     */
    private String logo;

    /**
     * 地理服务地址
     */
    private String geometryService;

    /**
     * 是否显示头部
     */
    private Boolean isShowHeader;

    /**
     * 是否展示切换是三维
     */
    private String globalUrl;

    /**
     * 地理服务地址
     */
    private String fileImportService;

    /**
     * 图形校验地址
     */
    private String examineGeometryUrl;

    /**
     * 导出excel地址
     */
    private String exportExcelService;

    /**
     * 导出word地址
     */
    private String exportWordService;

    /**
     * region
     */
    private String regionIndex;
    /**
     * map
     */
    private Map map;

    /**
     * 地图 widgets
     */
    private List<Widget> widgets;


    /**
     * 地图 tools
     */
    private List<Widget> tools;


    /**
     * 地图样式控制
     */
    private String widgetStyle;
    /**
     * 地图控制器 eg. zoomControl
     */
    private List<ControlWidget> controls;

    /**
     * 当前模版标题
     */
    private String templateName;

    /**
     * 分析是否绘制多面配置
     */
    private boolean drawMulti;

    /**
     * 其他配置
     */
    private java.util.Map config;

    public static final class Map implements Serializable {

        private List<ResourceLayer> baseLayers;
        private List<ResourceLayer> layers;
        private java.util.Map options;


        public Map() {
            baseLayers = new ArrayList<>();
            layers = new ArrayList<>();
        }

        public List<ResourceLayer> getBaseLayers() {
            return baseLayers;
        }

        public void setBaseLayers(List<ResourceLayer> baseLayers) {
            this.baseLayers = baseLayers;
        }

        public List<ResourceLayer> getLayers() {
            return layers;
        }

        public void setLayers(List<ResourceLayer> layers) {
            this.layers = layers;
        }

        public java.util.Map getOptions() {
            return options;
        }

        public void setOptions(java.util.Map options) {
            this.options = options;
        }

    }


    @Override
    public String getTitle() {
        return this.title;
    }
}
