package cn.gtmap.gtc.resource.domain.resource.dto.tpl;

import cn.gtmap.gtc.resource.domain.BaseEntity;
import cn.gtmap.gtc.resource.domain.core.Enable;
import cn.gtmap.gtc.resource.domain.core.Title;
import cn.gtmap.gtc.resource.domain.resource.dto.tpl.map.Configuration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Type;

import javax.persistence.*;

/**
 * . 地图模板
 *
 * @author <a href="mailto:yingxiufeng@gtmap.cn">alex.y</a>
 * @version v1.0, 2018/3/27 (c) Copyright gtmap Corp.
 */
@Entity
@Table(name = "gt_tpl")
public class Tpl extends BaseEntity implements Title, Enable {

    /**
     * 标题
     */
    @Getter
    @Setter
    private String title;

    /**
     * 模板对应的地图空间参考
     * eg. EPSG:2364
     */
    @Getter
    @Setter
    private String sr;

    /**
     * 模板logo
     */
    @Getter
    @Setter
    private String logo;

    /**
     * 行政区代码
     */
    @Getter
    @Setter

    private String regionCode;

    /**
     * 模板对应的内容
     */
    @Setter
    private Configuration content;

    @Lob
    @Basic(fetch = FetchType.LAZY)
//    @Column(columnDefinition = "json")
    @Type(type = "json")
    public Configuration getContent() {
        return content;
    }

    @Override
    public String getTitle() {
    return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSr() {
        return sr;
    }

    public void setSr(String sr) {
        this.sr = sr;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public void setContent(Configuration content) {
        this.content = content;
    }

}
