package cn.gtmap.gtc.resource.domain.resource.dto.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.Capable;
import cn.gtmap.gtc.resource.domain.resource.metadata.Resource;
import cn.gtmap.gtc.resource.domain.resource.metadata.Responsible;
import cn.gtmap.gtc.resource.utils.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;

import static cn.gtmap.gtc.resource.Constant.NOTSHARE;
import static cn.gtmap.gtc.resource.Constant.UNCONDITIONAL;

/**
 * Created by zgl on 2017-12-20.
 */
public class ResourceViewBuilder {

    /**
     * build ResourceView by resource
     *
     * @param resource
     * @return
     */

    public ResourceView build(final Resource resource) {
        if (resource == null) {
            return null;
        }else{
            ResourceView resourceView = new ResourceView();
            resourceView.setId(resource.getId());
            resourceView.setType(resource.getType());
            resourceView.setTitle(resource.getTitle());
            resourceView.setIcon(resource.getIcon());
            if(!CollectionUtils.isEmpty(resource.getCapables())){
                resourceView.setCapables(resource.getCapables());
//                resourceView.setCapables(BeanUtil.copyBeanList(resource.getCapables(), CapableView.class));
            }
            resourceView.setSpatialCoverage(resource.getSpatialCoverage());
            resourceView.setWeight(resource.getWeight());
            resourceView.setResourceViewList(build(resource.getRelations()));
            resourceView.setDataResource(resource.getDataResource());
            resourceView.setChecked(resource.getChecked());
            resourceView.setResponsible(resource.getResponsible());
            resourceView.setCreateAt(resource.getCreateAt());
            resourceView.setUpdateAt(resource.getUpdateAt());
            resourceView.setNdStr(resource.getNdStr());
            resourceView.setPermission(resource.getPermission());
            resourceView.setCreator(resource.getCreator());
            resourceView.setDescription(resource.getDescription());
            resourceView.setIsPub(resource.getIsPub());
            if(UNCONDITIONAL.equals(resource.getPermission()) || NOTSHARE.equals(resource.getPermission())){
                resourceView.setApplyStatus(false);
            }else{
                resourceView.setApplyStatus(true);
            }
            try {
                JSONObject jsonObject = JSON.parseObject(resource.getSource());
                resourceView.setSource(jsonObject);
            } catch (Exception e) {
                resourceView.setSource(null);
                e.printStackTrace();
            }
            return resourceView;
        }
    }

    /**
     * build ResourceViewList by resourceList
     *
     * @param resourceList
     * @return
     */
    public List<ResourceView> build(final List<Resource> resourceList) {
        if (resourceList == null) {
            return new ArrayList<>();
        }else{
            List<ResourceView> resourceViewList = new ArrayList<>();
            for (Resource resource : resourceList) {
                resourceViewList.add(build(resource));
            }
            return resourceViewList;
        }
    }

    private String getValue(final Map<String,Object> map, String key){
        if(map.containsKey(key)){
            Object value = map.get(key);
            if(Objects.nonNull(value)){
                return (String)value;
            }
        }
        return "";
    }

    private Integer getInteger(final Map<String,Object> map, String key){
        if(map.containsKey(key)){
            Object value = map.get(key);
            if(Objects.nonNull(value)){
                return (Integer)value;
            }
        }
        return null;
    }

    private Date getDate(final Map<String,Object> map, String key){
        if(map.containsKey(key)){
            Object value = map.get(key);
            if(Objects.nonNull(value)){
                return (Date)value;
            }
        }
        return null;
    }

    private ResourceView mapBbuild(final Map<String,Object> map) {
        if (CollectionUtils.isEmpty(map)) {
            return null;
        }else{
            ResourceView resourceView = new ResourceView();
            resourceView.setId(getValue(map,"id"));
            resourceView.setType(getValue(map,"type"));
            resourceView.setTitle(getValue(map,"title"));
            resourceView.setIcon(getValue(map,"icon"));
            resourceView.setWeight(getInteger(map,"weight"));
            resourceView.setDataResource(getValue(map,"data_resource"));
            resourceView.setChecked(getInteger(map,"checked"));
            resourceView.setCreateAt(getDate(map,"create_at"));
            resourceView.setUpdateAt(getDate(map,"update_at"));
            resourceView.setNdStr(getValue(map,"nd_str"));
            resourceView.setPermission(getValue(map,"permission"));
            resourceView.setCreator(getValue(map,"creator"));
            resourceView.setDescription(getValue(map,"description"));
            resourceView.setIsPub(getInteger(map,"is_pub"));
            if(UNCONDITIONAL.equals(resourceView.getPermission()) || NOTSHARE.equals(resourceView.getPermission())){
                resourceView.setApplyStatus(false);
            }else{
                resourceView.setApplyStatus(true);
            }
            Responsible responsible = new Responsible();
            responsible.setOrgnizationName(getValue(map,"orgnization_name"));
            resourceView.setResponsible(responsible);
            /*try {
                JSONObject jsonObject = JSON.parseObject(resource.getSource());
                resourceView.setSource(jsonObject);
            } catch (Exception e) {
                resourceView.setSource(null);
                e.printStackTrace();
            }
            if(!CollectionUtils.isEmpty(resource.getCapables())){
                resourceView.setCapables(resource.getCapables());
            }
            resourceView.setSpatialCoverage(resource.getSpatialCoverage());
            resourceView.setResourceViewList(build(resource.getRelations()));
            */
            return resourceView;
        }
    }

    public List<ResourceView> listBuild(final List<Map<String,Object>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }else{
            List<ResourceView> resourceViewList = new ArrayList<>();
            for (Map<String,Object> map : list) {
                resourceViewList.add(mapBbuild(map));
            }
            return resourceViewList;
        }
    }

}
