package cn.gtmap.gtc.resource.domain.resource.dto.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.Resource;
import cn.gtmap.gtc.resource.domain.resource.metadata.Responsible;
import cn.gtmap.gtc.resource.domain.resource.metadata.SpatialCoverage;
import com.alibaba.fastjson.JSONObject;

import java.util.Date;
import java.util.List;

/**
 * resource view
 *
 * @author monarchCheng
 * @create 2017-11-13 15:56
 **/
public class ResourceView<T> {

    private String id;
    /**
     * 标题["ff80808174393aa60174570484580297","ff80808174393aa6017457048477029d","ff80808174393aa601745704849b02a3"]
     */
    private String title;
    /**
     * 描述
     */
    private String description;

    /**
     *
     */
    private Date createAt;

    /**
     * 更新时间
     */
    private Date updateAt;
    /**
     * 关键字
     */
    private List<String> keywordIds;

    /**
     * Collection
     * Dataset
     * Event
     * Image
     * InteractiveResource
     * MovingImage
     * Service
     * Software
     * Sound
     * Text
     */
    private String type;
    /**
     * Media MINE Type
     */
    private String format;
    /**
     * 创建者
     */
    private String creator;
    /**
     * 发布者
     */
    private String publisher;

    /**
     * 时间范围，开始时间
     */
    private Date startAt;

    /**
     * 时间范围，结束时间
     */
    private Date endAt;


    /**
     * 资源权限描述
     */
    private String rights;

    /**
     * 资源具体描述
     */
    private JSONObject source;

    /**
     * 缩略图地址
     */
    private String imgUrl;
    /**
     * 空间覆盖范围
     */
    private SpatialCoverage spatialCoverage;

    /**
     * 关联资源，比如聚合拆分多资源关系体现
     */
    private List<String> resourceIds;

    /**
     * 关联资源，比如聚合拆分多资源关系体现
     */
    private List<ResourceView> resourceViewList;

    private List<ResourceAppendView> append;

    /**
     * 归属资源目录
     */
    private List<String> catalogIds;

    /**
     * 资源同步目录
     */
    private List<CatalogView> catalogViewList;
    /**
     * 行政机关
     */
    private List<String> xzjgIds;

    /**
     * 行政机关
     */
    private List<String> zszxIds;
    /**
     * 资源目录
     */
    private List<String> rescIds;
    /**
     * 资源能力id
     *
     * @return
     */
    private List<String> capableIds;


    /**
     * 资源能力
     */
    private List<CapableView> capables;


    /**
     * 缩略图id
     */
    private String icon;


    /**
     * 责任单位信息
     */
    private Responsible responsible;

    /**
     * 行政区划
     */
    private String regionCode;

    /**
     * 行政区划名称
     */
    private String regionName;

    /**
     * 资源权重
     */
    private Integer weight;

    /**
     * 注册资源，下载资源
     */
    private String status;

    //使用权限
    private String permission;

    //投影类型
    private String projection;

    //资源来源
    private String dataResource;

    //是否已经注册
    private String registerStatus;

    //更新周期
    private String resourceGxzq;

    //年度字段
    private String ndStr;

    /**
     * 资源是否审核发布
     */
    private Integer checked = 1;

    /**
     * 申请统计
     */
    private Integer applyCount = 0;

    /**
     * 访问统计
     */
    private Integer authenticationCount = 0;

    //申请状态
    private boolean applyStatus;

    /**
     * 是否是创建者
     */
    private Boolean isCreator;

    /**
     * 访问量
     */
    private long authCount;

    /**
     * 是否公开
     */
    private int isPub;

    /*
     * 资源中心目录类型
     */
    private String typeId;

    public String getProjection() {
        return projection;
    }

    public void setProjection(String projection) {
        this.projection = projection;
    }

    public String getPermission() {
        return permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    /**
     * 星级
     */
    private int rate;

    public int getRate() {
        return rate;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    public List<String> getRescIds() {
        return rescIds;
    }

    public void setRescIds(List<String> rescIds) {
        this.rescIds = rescIds;
    }

    public List<String> getXzjgIds() {
        return xzjgIds;
    }

    public void setXzjgIds(List<String> xzjgIds) {
        this.xzjgIds = xzjgIds;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getKeywordIds() {
        return keywordIds;
    }

    public void setKeywordIds(List<String> keywordIds) {
        this.keywordIds = keywordIds;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getPublisher() {
        return publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public Date getStartAt() {
        return startAt;
    }

    public void setStartAt(Date startAt) {
        this.startAt = startAt;
    }

    public Date getEndAt() {
        return endAt;
    }

    public void setEndAt(Date endAt) {
        this.endAt = endAt;
    }

    public String getRights() {
        return rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public JSONObject getSource() {
        return source;
    }

    public void setSource(JSONObject source) {
        this.source = source;
    }

    public SpatialCoverage getSpatialCoverage() {
        return spatialCoverage;
    }

    public void setSpatialCoverage(SpatialCoverage spatialCoverage) {
        this.spatialCoverage = spatialCoverage;
    }

    public List<String> getResourceIds() {
        return resourceIds;
    }

    public void setResourceIds(List<String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public List<String> getCatalogIds() {
        return catalogIds;
    }

    public void setCatalogIds(List<String> catalogIds) {
        this.catalogIds = catalogIds;
    }

    public List<String> getCapableIds() {
        return capableIds;
    }

    public void setCapableIds(List<String> capableIds) {
        this.capableIds = capableIds;
    }

    public List<CapableView> getCapables() {
        return capables;
    }

    public void setCapables(List<CapableView> capables) {
        this.capables = capables;
    }


    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Date getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Date createAt) {
        this.createAt = createAt;
    }

    public Responsible getResponsible() {
        return responsible;
    }

    public void setResponsible(Responsible responsible) {
        this.responsible = responsible;
    }

    public Date getUpdateAt() {
        return updateAt;
    }

    public void setUpdateAt(Date updateAt) {
        this.updateAt = updateAt;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }


    public List<ResourceView> getResourceViewList() {
        return resourceViewList;
    }

    public void setResourceViewList(List<ResourceView> resourceViewList) {
        this.resourceViewList = resourceViewList;
    }

    public List<ResourceAppendView> getAppend() {
        return append;
    }

    public void setAppend(List<ResourceAppendView> append) {
        this.append = append;
    }

    public List<CatalogView> getCatalogViewList() {
        return catalogViewList;
    }

    public void setCatalogViewList(List<CatalogView> catalogViewList) {
        this.catalogViewList = catalogViewList;
    }

    public String getDataResource() {
        return dataResource;
    }

    public void setDataResource(String dataResource) {
        this.dataResource = dataResource;
    }


    public String getRegisterStatus() {
        return registerStatus;
    }

    public void setRegisterStatus(String registerStatus) {
        this.registerStatus = registerStatus;
    }


    public String getResourceGxzq() {
        return resourceGxzq;
    }

    public void setResourceGxzq(String resourceGxzq) {
        this.resourceGxzq = resourceGxzq;
    }

    public String getNdStr() {
        return ndStr;
    }

    public void setNdStr(String ndStr) {
        this.ndStr = ndStr;
    }

    public Integer getChecked() {
        return checked;
    }

    public void setChecked(Integer checked) {
        this.checked = checked;
    }

    public List<String> getZszxIds() {
        return zszxIds;
    }

    public void setZszxIds(List<String> zszxIds) {
        this.zszxIds = zszxIds;
    }

    public Integer getApplyCount() {
        return applyCount;
    }

    public void setApplyCount(Integer applyCount) {
        this.applyCount = applyCount;
    }

    public Integer getAuthenticationCount() {
        return authenticationCount;
    }

    public void setAuthenticationCount(Integer authenticationCount) {
        this.authenticationCount = authenticationCount;
    }

    public boolean isApplyStatus() {
        return applyStatus;
    }

    public void setApplyStatus(boolean applyStatus) {
        this.applyStatus = applyStatus;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public long getAuthCount() {
        return authCount;
    }

    public void setAuthCount(long authCount) {
        this.authCount = authCount;
    }

    public int getIsPub() {
        return isPub;
    }

    public ResourceView<T> setIsPub(int isPub) {
        this.isPub = isPub;
        return this;
    }

    public String getTypeId() {
        return typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public Boolean getIsCreator() {
        return isCreator;
    }

    public void setIsCreator(Boolean creator) {
        this.isCreator = creator;
    }
}
