package cn.gtmap.gtc.resource.domain.resource.dto.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.ResourceLog;

import java.util.ArrayList;
import java.util.List;

/**
 * 1 * @Author: zgl
 * 2 * @Date: 2019/10/26 16:50
 * 3
 */
public class ResourceLogViewBuilder {

    /**
     *
     * @param resourceLog
     * @return
     */
    public ResourceLogView build(final ResourceLog resourceLog) {
        if (resourceLog == null) {
            return null;
        }else {
            ResourceLogView resourceLogView = new ResourceLogView();
            resourceLogView.setOperateLog(resourceLog.getOperateLog());
            resourceLogView.setOperateTime(resourceLog.getOperateTime());
            resourceLogView.setOperator(resourceLog.getOperator());
            return resourceLogView;
        }
    }

    /**
     *
     * @param resourceLogList
     * @return
     */
    public List<ResourceLogView> build(final List<ResourceLog> resourceLogList) {
        if (resourceLogList == null) {
            return new ArrayList<>();
        }else {
            List<ResourceLogView> resourceLogViewList = new ArrayList<>();
            for (ResourceLog resourceLog : resourceLogList) {
                resourceLogViewList.add(build(resourceLog));
            }
            return resourceLogViewList;
        }
    }
}
