package cn.gtmap.gtc.resource.domain.resource.dto.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.Menu;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author zgl
 * @date 2018-04-27
 */
public class MenuViewBuilder {

    /**
     * build menuView by menu
     *
     * @param menu
     * @return
     */
    public MenuView build(final Menu menu) {
        if (menu == null) {
            return null;
        }else {
            MenuView menuView = new MenuView();
            menuView.setId(menu.getId());
            menuView.setIcon(menu.getIcon());
            menuView.setCss(menu.getCss());
            menuView.setName(menu.getName());
            menuView.setUrl(menu.getUrl());
            menuView.setChildren(build(menu.getChildren()));
            menuView.setRemark(menu.getRemark());
            menuView.setWeight(menu.getWeight());
            menuView.setType(menu.getType());
            menuView.setUseRoute(menu.getUseRoute());
            return menuView;
        }
    }

    /**
     * build menuViews by menus
     *
     * @param menus
     * @return
     */
    public List<MenuView> build(final List<Menu> menus) {
        if (menus == null) {
            return new ArrayList<>();
        }else {
            List<MenuView> menuViewList = new ArrayList<>();
            for (Menu menu : menus) {
                menuViewList.add(build(menu));
            }
            return menuViewList;
        }
    }
}
