package cn.gtmap.gtc.resource.domain.resource.dto.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.Catalog;
import cn.gtmap.gtc.resource.utils.BeanUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * .CatalogViewBuilder
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/12/13 10:52
 */
public class CatalogViewBuilder {

    /**
     * build catalogview by catalog
     *
     * @param catalog
     * @return
     */
    public CatalogView build(final Catalog catalog) {
        if (catalog == null) {
            return null;
        }
        CatalogView catalogView = new CatalogView().setId(catalog.getId())
                .setTitle(catalog.getTitle())
                .setDescription(catalog.getDescription())
                .setType(catalog.getType())
                .setWeight(catalog.getWeight())
                .setCode(catalog.getCode())
                .setRemark(catalog.getRemark())
                .setExpandStr(catalog.getExpandStr());
        if(catalog.getParent() != null){
            CatalogView parent = new CatalogView();
            BeanUtil.copyBean(catalog.getParent(),parent);
            catalogView.setParent(parent);
        }
        catalogView.setChildren(build(catalog.getChildren()));
        return catalogView;
    }

    /**
     * build catalogviews by catalogs
     *
     * @param catalogs
     * @return
     */
    public List<CatalogView> build(final List<Catalog> catalogs) {
        if (catalogs == null) {
            return new ArrayList<>();
        }
        List<CatalogView> catalogViews = new ArrayList<>();
        for (Catalog catalog : catalogs) {
            catalogViews.add(build(catalog));
        }
        return catalogViews;
    }
}
