package cn.gtmap.gtc.resource.domain.resource.Theme;

import cn.gtmap.gtc.resource.domain.ID;
import com.alibaba.fastjson.JSON;

import javax.persistence.*;

/**
 * 专题图结果
 *
 * @author <a href="mailto:zhaozhuyi@gmail.com">zzy</a>
 * @version V1.0, 2019/9/24 15:43
 */
@Entity
@Table(name = "theme_data")
public class ThemeData<T> extends ID {

    @Column(name = "theme_id")
    private String themeId;

    @Column(name = "theme_name")
    private String themeName;

    @Column(name = "theme_params")
    private String themeParams;

    @Column(name = "theme_results")
    private String themeResults;

    @Column(name = "theme_year")
    private String themeYear;

    @Column(name = "theme_level")
    private String themeLevel;

    public String getThemeId() {
        return themeId;
    }

    public void setThemeId(String themeId) {
        this.themeId = themeId;
    }

    public String getThemeName() {
        return themeName;
    }

    public void setThemeName(String themeName) {
        this.themeName = themeName;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    public String getThemeParams() {
        return themeParams;
    }

    public ThemeData setThemeParams(T themeParams) {
        if (themeParams instanceof String) {
            this.themeParams = String.valueOf(themeParams);
        } else {
            try {
                this.themeParams = JSON.toJSONString(themeParams);
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                return this;
            }
        }
        return this;
    }

    @Basic(fetch = FetchType.LAZY)
    @Lob
    public String getThemeResults() {
        return themeResults;
    }

    public ThemeData setThemeResults(T themeResults) {
        if (themeResults instanceof String) {
            this.themeResults = String.valueOf(themeResults);
        } else {
            try {
                this.themeResults = JSON.toJSONString(themeResults);
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                return this;
            }
        }
        return this;
    }

    public String getThemeYear() {
        return themeYear;
    }

    public void setThemeYear(String themeYear) {
        this.themeYear = themeYear;
    }

    public String getThemeLevel() {
        return themeLevel;
    }

    public void setThemeLevel(String themeLevel) {
        this.themeLevel = themeLevel;
    }
}
