package cn.gtmap.gtc.resource.domain.dev;

import java.util.List;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/12/5
 * @description 目录bean
 */
public class Index extends EsEntity implements Comparable<Index> {

    /**
     * 目录id
     */
    private String id;

    /**
     * 是不是根目录
     */
    private String isroot;

    /**
     * 资源描述
     */
    private String description;

    /**
     * 资源层级
     */
    private int level;

    /**
     * 排序字段
     */
    private int sort;

    /**
     * 父资源ID(每个资源有一个或0个父目录)
     */
    private String parentid;

    /**
     * 是否是文章
     */
    private String isArticle;

    private List<Index> children;

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getIsroot() {
        return isroot;
    }

    public void setIsroot(String isroot) {
        this.isroot = isroot;
    }

    public String getParentid() {
        return parentid;
    }

    public void setParentid(String parentid) {
        this.parentid = parentid;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getSort() {
        return sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getIsArticle() { return isArticle; }

    public void setIsArticle(String isArticle) { this.isArticle = isArticle; }

    public List<Index> getChildren() { return children; }

    public void setChildren(List<Index> children) { this.children = children; }

    @Override
    public int compareTo(Index index) {
        return this.getSort() - index.getSort();
    }
}
