package cn.gtmap.gtc.resource.clients.server;

import cn.gtmap.gtc.resource.domain.server.ServerStatus;
import cn.gtmap.gtc.resource.domain.server.ServerStatusHis;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 1 * @Author: zgl
 * 2 * @Date: 2019/12/11 15:11
 * 3
 */
@FeignClient("resource-server")
@RequestMapping("/server")
public interface ServerStatusClient {

    @RequestMapping("/saveServerStatus")
    void saveServerStatus(@RequestBody ServerStatus serverStatus);


    @PostMapping("/saveList")
    void saveList(@RequestBody List<ServerStatus> serverStatusList);

    @RequestMapping("/queryServersByType")
    public List<String> queryServersByType(@RequestParam(name = "type") String type);

    @RequestMapping("/queryServersById")
    ServerStatus queryServersById(@RequestParam(name = "id") String id);

    @RequestMapping("/updateServerById")
    String updateServerById(@RequestParam(name = "id") String id,@RequestParam(name = "serverStatus") String serverStatus,
                            @RequestParam(name = "remark") String remark);


    @RequestMapping("/getWarnTips")
    public String getWarnTips();

    @RequestMapping("/getSevenDaysData")
    public List<String> getSevenDaysData();

    @GetMapping("/getServerStatusByPage")
    Page<ServerStatus> getServerStatusByPage(@RequestParam(name = "title") String title, Pageable pageable);

    @GetMapping("/getServerStatusHisByPage")
    Page<ServerStatusHis> getServerStatusHisByPage(@RequestParam(name = "serverId") String serverId, Pageable pageable);



}
