package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.config.response.ResponseData;
import cn.gtmap.gtc.resource.domain.resource.metadata.ServiceIpport;
import cn.gtmap.gtc.resource.domain.resource.metadata.ServiceLayer;
import cn.gtmap.gtc.resource.domain.resource.metadata.Services;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.util.*;

@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/services")
public interface ServicesClient {

 //数管中心接口 ↓
 @GetMapping("/findAllServiceIpPort")
 Map findAllServiceIpPort(@RequestParam(name = "pageNo", required = false, defaultValue = "1") String pageNo,
                          @RequestParam(name = "pageSize", required = false, defaultValue = "10") String pageSize);

 @PostMapping("/saveIpPort")
 Map saveIpPort(@RequestBody ServiceIpport serviceIpport);

 @GetMapping("/checkIpportUrl")
 Boolean checkIpportUrl(@RequestParam(name = "url") String url);

 @GetMapping("/deleteIpPort/{id}")
 Map deleteIpPort(@PathVariable(name = "id") String id);

 @PostMapping("/saveTemplate")
 Map saveTemplate(@RequestBody JSONObject template);

 @GetMapping("/queryAllTemplate")
 Map queryAllTemplate();

 @GetMapping("/deleteTemplate/{id}")
 Map deleteTemplate(@PathVariable(name = "id") String id);

 @PostMapping("/checkTemplate")
 Map checkTemplate(@RequestParam(name = "path") String path,
                   @RequestParam(name = "storageid") String storageid,
                   @RequestParam(name = "storagedownurl") String  storagedownurl) throws IOException;

 //数管中心接口 ↑

 //资源中心接口 ↓
 @GetMapping("/getTemplateTable")
 Map getTemplateTable();

 @GetMapping("/getPortTable")
 Map getPortTable();

 @GetMapping("/uploadShpZip")
 Map uploadShpZip(@RequestParam(name = "file") MultipartFile file,
                  @RequestParam(name = "templateId") String templateId,
                  @RequestParam(name = "ipportId") String ipportId) throws IOException;

 @PostMapping("/saveService")
 Map saveService(@RequestBody JSONObject jsonObject);

 @GetMapping("/downTemplate")
 Map downTemplate(@RequestParam(name = "id") String id);

 @GetMapping("/queryAllServices")
 Map queryAllServices(@RequestParam(name = "pageNo", required = false, defaultValue = "1") String page,
                      @RequestParam(name = "pageSize", required = false, defaultValue = "10") String size,
                      @RequestParam(name ="year", required = false) String year,
                      @RequestParam(name ="datasource", required = false) String datasource,
                      @RequestParam(name ="type", required = false) String type);

 @GetMapping("/deleteServiceById/{id}")
 Map deleteServiceById(@PathVariable(name = "id") String id);

 @GetMapping("/getCatalog/{type}")
 Map getCatalog(@PathVariable(name = "type") String type);

 @PutMapping("ServiceControl")
 Map ServiceControl(@RequestParam(name = "id") String id, @RequestParam(name = "type") String type);

 @GetMapping("getServiceFullUrl")
 Map getServiceFullUrl(@RequestParam(name = "url") String url);

 @PostMapping("/getDownServices")
 public ResponseData getDownServices(@RequestParam("keyWord") String keyWord, Pageable pageable);
 //资源中心接口 ↑

}
