package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.dto.resource.ResourceLayer;
import cn.gtmap.gtc.resource.domain.resource.dto.resource.ResourceView;
import cn.gtmap.gtc.resource.domain.resource.metadata.Capable;
import cn.gtmap.gtc.resource.domain.resource.metadata.Resource;
import cn.gtmap.gtc.resource.domain.resource.metadata.ResourceUserRef;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * resource client
 *
 * @author zhuzhifeng
 * @create 2018年11月15日16:37:32
 **/
@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/resourceMap")
public interface ResourceMapClient {

    /**
     * 根据资源目录和行政区查询资源
     */
    @RequestMapping("/query/condition2")
    List<ResourceView> condition2(@RequestParam(name = "catalog", required = false) String catalogId,
                                  @RequestParam(name = "type", required = false) String type,
                                  @RequestParam(name = "region", required = false) String regionCode);
    @PostMapping("/query/queryMapResourceByCondition")
    Page<ResourceLayer> queryMapResourceByCondition(
            @RequestParam(name = "keyword", required = false) String keyword,
            @RequestParam(name = "catalogId", required = false) String catalogId,
            @RequestParam(name = "type", required = false) String type,
            Pageable pageable);

    @PostMapping("/query/findResourcesListByUserId")
    List<ResourceView> findResourcesListByUserId(@RequestParam(name = "userId", required = false) List<String> userId);

    /**
     * 根据用户id查询收藏的资源
     * @param userId 用户id
     * @return List<Resource>
     */
    @PostMapping("/query/findFavResListByUserId")
    Map findFavResListByUserId(@RequestParam(name = "userId") String userId);

    /**
     * 根据资源名称查询该资源
     * @param resourceName 资源名称
     * @return List<Resource>
     */
    @PostMapping("/query/findFavResListByResName")
    Map findFavResListByResName(@RequestParam(name = "userId") String userId, @RequestParam(name = "resourceName") String resourceName);


    /**
     * 保存用户id和其对应的选择资源的id
     * @param userId 用户id
     * @param resourceName 资源名称
     * @param isFavorite 是否是用户的收藏
     * @param resourceIds 资源id
     * @return boolean
     */
    @RequestMapping("/save/saveResourceAndUserRef")
    Iterable<ResourceUserRef> saveResourceAndUserRef(@RequestParam(name = "userId", required = false) String userId,
                                                     @RequestParam(name = "resourceName", required = false) String resourceName,
                                                     @RequestParam(name = "isFavorite", required = false) Boolean isFavorite,
                                                     @RequestParam(name = "resourceIds", required = false) List<String> resourceIds);

    /**
     * 根据用户id和资源id删除对应收藏数据
     * @param userId 用户id
     * @param resourceIds 资源列表
     * @return boolean
     */
    @RequestMapping("/delete/deleteFavRes")
    Boolean deleteFavRes(@RequestParam(name = "userId", required = false) String userId,
                         @RequestParam(name = "resourceIds", required = false) List<String> resourceIds);

    /**
     * 根据用户id 删除用户对应非收藏的数据
     * @param userId 用户id
     * @return boolean
     */
    @RequestMapping("/delete/deleteNoFavRes")
    Boolean deleteNoFavRes(@RequestParam(name = "userId", required = false) String userId);


    /**
     * 根据用户id和资源id查询该资源是否是该用户的收藏资源
     * @param userId 用户id
     * @return List<Resource>
     */
    @PostMapping("/query/forUserIsFavRes")
    Boolean forUserIsFavRes(@RequestParam(name = "userId", required = false) String userId,
                            @RequestParam(name = "resourceIds", required = false) List<String> resourceIds);


    @PostMapping("/query/findResourceIdByCatalogId")
    List<String> findResourceIdByCatalogId(@RequestParam(name = "catalogId", required = false) String catalogId);

    /**
     * 我的收藏，编辑默认加载图层
     * @param userId
     * @param type
     * @param resourceId
     * @return
     */
    @RequestMapping("/edit/editResourceAndUserRef")
    Boolean editResourceAndUserRef(@RequestParam(name = "userId") String userId,
                                   @RequestParam(name = "type") String type,
                                   @RequestParam(name = "resourceId") String resourceId);
}
