package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.config.response.ResponseData;
import cn.gtmap.gtc.resource.domain.resource.metadata.ResourceStatus;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.util.Map;

@FeignClient(name = "${app.services.resource-core:resource-core}")
@RequestMapping("/resource/check")
public interface ResourceCheckClient {

    @GetMapping("/getProcess")
    public ResponseData getProcess();

    @GetMapping("/statusCheck")
    public ResponseData checkStatus();

    @GetMapping("/statusCheckTime")
    public ResponseData checkStatusTime();

    @GetMapping("/isCheckRunning")
    public ResponseData isCheckRunning(@RequestParam("isCheck") boolean isCheck);

    @RequestMapping("/currentResourceStatusStatistics")
    public ResponseData currentResourceStatusStatistics();

    @RequestMapping("/historicalResourceStatusStatistics")
    public ResponseData historicalResourceStatusStatistics(@RequestParam("timeInterval") String timeInterval);

    @RequestMapping("/getDownResourcesByKeyWord")
    public ResponseData getDownResourcesByKeyWord(@RequestParam("keyWord") String keyWord, Pageable pageable);

    @RequestMapping("/getDownResourcesByDate")
    public ResponseData getDownResourcesByDate(@RequestParam(value = "startDate") String startDate, @RequestParam(value = "endDate") String endDate, Pageable pageable);

    @RequestMapping("/getDownResources")
    public ResponseData getDownResources(Pageable pageable);

    @GetMapping("/getAlarms")
    public ResponseData getAlarms(@RequestParam("start") String start, @RequestParam("end") String end, @RequestParam(value = "alarmType", required = false) String alarmType, Pageable pageable);

    @RequestMapping("/getResourceStatus")
    public ResponseData getResourceStatus(@RequestParam("resourceId") String resourceId);

    @RequestMapping("/checkResourceStatus")
    public ResponseData checkResourceStatus(@RequestParam("resourceId") String resourceId);

    @RequestMapping("/getMonitorRoleCode")
    public ResponseData getMonitorRoleCode(Principal principal);

    /**
     * 获取指定id资源状态信息集合
     * @param resourceIdsMap 资源Id集合
     * @return
     */
    @RequestMapping("/queryResStatus")
    Map queryResourceStatusByResourceId(@RequestBody Map resourceIdsMap);
}
