package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.dto.resource.*;
import cn.gtmap.gtc.resource.domain.resource.metadata.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.util.List;
import java.util.Map;

/**
 * resource client
 *
 * @author monarchCheng
 * @create 2017-11-14 10:47
 **/
@FeignClient(name = "${app.services.resource-core:resource-core}")
@RequestMapping("/res/v2")
public interface NewResClient {

    @PostMapping("/save/res")
    public Map saveRes(@RequestBody ResourceView resourceView);

    @PostMapping("/save/multi/res")
    public Map saveMultiRes(@RequestBody List<ResourceView> resourceViewList);

    /**
     * 根据数据库中资源注册记录，刷新es库中的记录
     * @param resourceIdStr 需要写es记录的资源id字符串
     * @return 操作是否成功
     */
    @RequestMapping("/reset/save")
    public boolean resetSave(@RequestParam(name = "resourceIdStr", required = false) String resourceIdStr);


    @PostMapping("/query/res/condition")
    public Page<ResourceView> queryResCondition(@RequestBody Map params);

    @RequestMapping("/query/dicts")
    public Map queryDicts(@RequestParam(name = "catalog", required = false) String catalog,
                          @RequestParam(name = "serverCatalog", required = false) String serverCatalog,
                          @RequestParam(name = "department", required = false) String department,
                          @RequestParam(name = "resDate", required = false) String resDate,
                          @RequestParam(name = "layerDate", required = false) String layerDate,
                          @RequestParam(name = "dataSources", required = false) String dataSources,
                          @RequestParam(name = "nd", required = false) String nd,
                          @RequestParam(name = "keywords", required = false) String keywords,
                          @RequestParam(name = "spatialCoverage", required = false) String spatialCoverage,
                          @RequestParam(name = "permission", required = false) String permission);

    @PostMapping("/apply/res")
    public Map applyRes(@RequestBody Map map);

    @RequestMapping("/query/apply")
    public Page<Map> queryApply(@RequestParam(name = "keyword", required = false) String keyword,
                                @RequestParam(name = "applyState") String applyState, Pageable pageable);

    /**
     * 查询数据下载申请列表
     *
     * @param applyContent 申请内容（标题）
     * @param regionName 行政区
     * @param applicant 申请人
     * @param searchStart 查询开始时间
     * @param searchEnd 查询结束时间
     * @param pageable 分页参数
     * @return Page<Map> 所有数据下载的申请列表
     */
    @RequestMapping("/query/dataDownload/apply")
    Page<Map> queryDataDownloadApplyList(@RequestParam(name = "applyContent", required = false) String applyContent,
                                         @RequestParam(name = "regionName", required = false) String regionName,
                                         @RequestParam(name = "applicant", required = false) String applicant,
                                         @RequestParam(name = "applyState", required = false) String applyState,
                                         @RequestParam(name = "searchTimeStart", required = false) String searchStart,
                                         @RequestParam(name = "searchTimeEnd", required = false) String searchEnd,
                                         Pageable pageable) ;

    @PostMapping("/approval")
    public Map approval(@RequestBody List<Map> mapList);

    @PostMapping("/back")
    public Map back(@RequestBody Map map);

    @GetMapping("/query/approvalNumber")
    public int getUncheckedApprovalNumber();

    @RequestMapping("/query/approval")
    public Page<Map> getApprovalList(@RequestParam(name = "keyword", required = false) String keyword,
                                     @RequestParam(name = "applyState") String applyState, Pageable pageable);

    @PostMapping("/authorize/res")
    public Map authorizeRes(@RequestBody Map map);

    @GetMapping("/query/res")
    ResourceView queryResById(@RequestParam(name = "id") String id);

    @GetMapping("/token/url")
    String queryTokenUrl(@RequestParam(name = "capableType") String capableType, @RequestParam(name = "capableId") String capableId, @RequestParam(name = "resId") String resId);

    @GetMapping("/query/apply/taskId")
    public Map queryApplys(@RequestParam(name = "taskId") String taskId);

    @GetMapping("/query/his/taskId")
    public List<ApplyRefHis> queryApplyHis(@RequestParam(name = "taskId") String taskId);

    @PostMapping("/del/res")
    public Map delRes(@RequestBody Map map);

    /**
     * 根据id集合查询代理地址和其他资源
     * @author gt-weiran
     * @date 2020-09-05
     * @param map 查询id集合
     * @return Map
     */
    @PostMapping("/query/res/idList")
    public Map queryResByIdList(@RequestBody Map map);

    @GetMapping("/getPermissionNum")
    public List<Map> getPermissionNum();

    @GetMapping("/queryResKw")
    public List<Map> queryResKw();

    @GetMapping("/checkResName")
    public Map checkResName(@RequestParam(name = "names") String names);

    @GetMapping("/checkResPer")
    public Boolean checkResPermission(@RequestParam(name="resId") String resId);

    @GetMapping("/number")
    public long getResourceNumber(String resId);

}
