package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.dto.resource.MenuView;
import cn.gtmap.gtc.resource.domain.resource.metadata.Menu;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.util.List;
import java.util.Map;

/**
 *
 * @author zgl
 * @date 2018-04-27
 */
@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/menu")
public interface MenuClient {

    @RequestMapping("saveMenu")
    public Menu saveMenu(Menu menu);

    @RequestMapping("saveMenuParams")
    public Menu saveMenuParams(@RequestParam(name = "parentId", required = false) String parentId,
                               @RequestParam(name = "id", required = false) String id,
                               @RequestParam(name = "name", required = false) String name,
                               @RequestParam(name = "type", required = false) String type,
                               @RequestParam(name = "url", required = false) String url,
                               @RequestParam(name = "remark", required = false) String remark,
                               @RequestParam(name = "isAdd", required = false) boolean isAdd,
                               @RequestParam(name = "icon", required = false) String icon,
                               @RequestParam(name = "css", required = false) String css,
                               @RequestParam(name = "useRoute",required = false) boolean useRoute);


    @RequestMapping("/deleteMenu/{id}")
    public void deleteMenu(@PathVariable(name = "id") String id);

    @RequestMapping("/query/getAllMenus")
    public List<MenuView> getAllMenus();

    @GetMapping("/query/findMenuById")
    MenuView findMenuById(@RequestParam(name = "id", required = false) String id);

    @RequestMapping("/query/findMenuByIdAndAndTypeAndParentIsNullOrderByWeightAsc")
    MenuView findMenuByIdAndAndTypeAndParentIsNullOrderByWeightAsc(@RequestParam(name = "id", required = false) String id, @RequestParam(name = "type", required = false) String type);

    @RequestMapping("/updateMenu")
    public Menu updateMenu(@RequestParam(name = "nodeArr") String nodeArr, @RequestParam(name = "type") String type);

    @GetMapping("/associate/associateMenuAndRoleList")
    public String associateMenuAndRoles(@RequestParam(name = "menuId") String menuId,
                                      @RequestParam(name = "roleIds") String roles,
                                      @RequestParam(name = "replaceAll", required = false) boolean replace);

    @PostMapping("/associate/associateRoleAndMenuList")
    public String associateRoleAndMenuList(@RequestBody Map params);

    @RequestMapping("/remove/removeMenuAndRoleList")
    public String removeMenuAndRole(@RequestParam(name = "menuId") String menuId,
                                     @RequestParam(name = "roleId") String roleId);

    @RequestMapping("/query/queryMenuRoleRefsByMenuId")
    List<String> queryMenuRoleRefsByMenuId(@RequestParam(name = "menuId", required = false) String menuId);

    @RequestMapping("/query/queryMenuRoleRefsByRoleId")
    List<String> queryMenuRoleRefsByRoleId(@RequestParam(name = "roleId", required = false) String roleId);

    @RequestMapping("/query/findListMenuByIdAndAndTypeAndParentIsNullOrderByWeightAsc")
    List<MenuView> findListMenuByIdAndAndTypeAndParentIsNullOrderByWeightAsc(@RequestParam(name = "ids", required = false) List<String> ids, @RequestParam(name = "type", required = false) String type);

    /**
     * 获取当前登录用户权限
     *
     * @return
     */
    @RequestMapping("/get/user/permissions")
    public Map getCurrentUserPermissions(@RequestParam(name = "userName", required = false) String userName,@RequestParam(name = "type", required = false) String type);
}
