package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.filecenter.FileCenterModule;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.security.Principal;
import java.util.List;
import java.util.Map;

@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/fileCenterModule")
public interface FileCenterModuleClient {

    /**
     * 保存模块文件信息
     * @param fileCenterModules
     * @return
     */
    @RequestMapping("/saveModules")
    public List<FileCenterModule> saveModules (@RequestBody List<FileCenterModule> fileCenterModules);

    /**
     * 删除模块文件信息
     * @param fileCenterModules
     */
    @RequestMapping("/deleteModules")
    public void deleteModules(@RequestBody List<FileCenterModule> fileCenterModules);

    /**
     * 根据用户名查找文档模块
     * @param username
     * @return
     */
    @RequestMapping("/queryModulesByUsername")
    public List<FileCenterModule> queryModulesByUsername(@RequestParam(name = "username") String username);

    /**
     * 根据id获取对应文档模块
     * @param id
     * @return
     */
    @RequestMapping("/getModuleById")
    public FileCenterModule getModuleById(@RequestParam(name = "id") String id);

    /**
     * 查询所有模块
     * @return
     */
    @RequestMapping("/findModulesDisplay")
    public List<Map> findModulesDisplay();

    /**
     * 根据一系列id找到所有模块
     * @param ids
     * @return
     */
    @RequestMapping("/queryModulesByids")
    public List<FileCenterModule> queryModulesByids(@RequestBody List<String> ids);

}
