package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.dict.XzqDict;
import cn.gtmap.gtc.resource.domain.resource.metadata.Dict;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author zgl
 * @date 2018-03-16
 */
@FeignClient(name = "${app.services.resource-core:resource-core}")
@RequestMapping("/dict")
public interface DictClient {

    /**
     * 保存dict
     *
     * @param dict
     * @return
     */
    @PostMapping("/saveDict")
    public Dict saveDict(@RequestBody Dict dict);

    /**
     * 根据type查询catalogIds
     *
     * @param type
     * @return
     */
    @RequestMapping("/findDictByType/type/{type}")
    Dict findDictByType(@PathVariable(name = "type") String type);

    /**
     * 根据types查询字典项列表
     * @param typeString
     * @return
     */
    @RequestMapping("/findDictByTypes/types/{types}")
    List<Dict> findDictByTypes(@PathVariable(name = "types") String typeString);

    /**
     * 根据key查询dict
     *
     * @param key
     * @return
     */
    @RequestMapping("/findValueByKey/key/{key}")
    Dict findValueByKey(@PathVariable(name = "key") String key);

    /**
     * 根据parentId查询dictList
     *
     * @param parentId
     * @return
     */
    @RequestMapping("/findDefaultDicts/parentId/{parentId}")
    List<Dict> findDefaultDicts(@PathVariable(name = "parentId") String parentId);

    /**
     * 根据parentId查询dictList
     *
     * @return
     */
    @RequestMapping("/findRootDicts")
    List<Dict> findRootDicts();

    /**
     * 保存dict
     */
    @PostMapping("/saveDictParams")
    public Dict saveDictParams(@RequestBody Map params);

    @RequestMapping("/deleteDict/{id}")
    public void deleteDict(@PathVariable(name = "id") String id);


    @RequestMapping("/updateDict")
    public Dict updateDict(@RequestParam(name = "nodeArr") String nodeArr, @RequestParam(name = "type") String type);

    /**
     * 根据dicId查询dict
     *
     * @param dicId
     * @return
     */
    @RequestMapping("/findDictByDicId/dicId/{dicId}")
    Dict findDictByDicId(@PathVariable(name = "dicId") String dicId);

    @RequestMapping("/queryDictsByType")
    List<Dict> queryDictsByType(@RequestParam(name = "type") String type);

    /**
     *保存行政区字典表
     *
     * @param xzqDictList
     * @return
     */
    @PostMapping("/save/xzq/dict")
    Map saveXzqDict(@RequestBody List<XzqDict> xzqDictList);


    /**
     * 根据xzqdm查询行政区字典表
     *
     * @param xzqdm
     * @return
     */
    @RequestMapping("/find/xzq/{xzqdm}")
    List<XzqDict> findXzqDict(@PathVariable(name = "xzqdm") String xzqdm);

    /**
     * 根据父的key获取下面两级的子字典项
     * @param dicKey
     * @return
     */
    @GetMapping("/findChildrenByParentKey/{dicKey}")
    Map<String,List<Dict>> findChildrenByParentKey(@PathVariable(name="dicKey") String dicKey);

}
